/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.sync.ChangedTeamContainer;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.sync.UnchangedTeamContainer;
import org.eclipse.team.internal.ui.target.TargetSyncCompareInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class TargetSyncAction
extends Action {
    private TargetSyncCompareInput diffModel;
    private ISelectionProvider selectionProvider;
    protected int syncMode;
    private Shell shell;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected static IRemoteResource getRemoteResourceFor(IResource local) throws TeamException {
        return TargetManager.getProvider((IProject)local.getProject()).getRemoteResourceFor(local);
    }

    public TargetSyncAction(TargetSyncCompareInput model, ISelectionProvider sp, String label, Shell shell) {
        super(label);
        this.diffModel = model;
        this.selectionProvider = sp;
        this.shell = shell;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected TargetSyncCompareInput getDiffModel() {
        return this.diffModel;
    }

    private boolean isEnabled(Object[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            ITeamNode node;
            if (nodes[i] instanceof ITeamNode ? this.isEnabled(node = (ITeamNode)nodes[i]) : nodes[i] instanceof IDiffContainer && this.isEnabled(((IDiffContainer)nodes[i]).getChildren())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract boolean isEnabled(ITeamNode var1);

    public void run() {
        ISelection s = this.selectionProvider.getSelection();
        if (!(s instanceof IStructuredSelection) || s.isEmpty()) {
            return;
        }
        final SyncSet set = new SyncSet((IStructuredSelection)s);
        this.removeNonApplicableNodes(set, this.syncMode);
        final SyncSet[] result = new SyncSet[1];
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                result[0] = TargetSyncAction.this.run(set, monitor);
            }
        };
        try {
            this.run((IRunnableWithProgress)op, Policy.bind("TargetSyncAction.errorEncountered"));
        }
        catch (InterruptedException interruptedException) {}
        if (result[0] != null) {
            this.removeNodes(result[0].getChangedNodes());
            this.diffModel.updateView();
        }
    }

    protected abstract void removeNonApplicableNodes(SyncSet var1, int var2);

    private void removeNodes(ITeamNode[] nodes) {
        new HashSet();
        int i = 0;
        while (i < nodes.length) {
            Class<?> clazz = nodes[i].getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.team.internal.ui.sync.UnchangedTeamContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                ChangedTeamContainer container;
                IDiffElement[] children;
                Class<?> clazz3 = nodes[i].getClass();
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.team.internal.ui.sync.ChangedTeamContainer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 == clazz4 && (children = (container = (ChangedTeamContainer)nodes[i]).getChildren()).length > 0) {
                    IDiffContainer parent = container.getParent();
                    UnchangedTeamContainer unchanged = new UnchangedTeamContainer(parent, container.getResource());
                    int j = 0;
                    while (j < children.length) {
                        unchanged.add(children[j]);
                        ++j;
                    }
                    parent.removeToRoot((IDiffElement)container);
                } else {
                    nodes[i].getParent().removeToRoot((IDiffElement)nodes[i]);
                }
            }
            ++i;
        }
    }

    public void update(int syncMode) {
        this.syncMode = syncMode;
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        this.setEnabled(this.isEnabled(selection.toArray()));
    }

    protected abstract SyncSet run(SyncSet var1, IProgressMonitor var2);

    protected void run(IRunnableWithProgress op, String problemMessage) throws InterruptedException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            Object error = null;
            error = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.team.ui", 1, Policy.bind("simpleInternal"), throwable);
            ErrorDialog.openError((Shell)this.shell, (String)problemMessage, (String)error.getMessage(), (IStatus)error);
            TeamUIPlugin.log(error);
        }
    }

    protected boolean saveIfNecessary() {
        return this.getDiffModel().saveIfNecessary();
    }

    protected Hashtable getTargetProviderMapping(IResource[] resources) throws TeamException {
        Hashtable<TargetProvider, ArrayList<IResource>> result = new Hashtable<TargetProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            TargetProvider provider = TargetManager.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }
}

