/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.target.ISiteFactory;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.target.ImportTargetSiteMainPage;
import org.eclipse.team.internal.ui.target.TargetSiteContentHandler;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TargetSiteImportWizard
extends Wizard
implements IImportWizard {
    public static String lastFile;
    private ImportTargetSiteMainPage mainPage;

    Site getSite(Properties properties) {
        try {
            URL url = new URL(properties.getProperty("location"));
            return TargetManager.getSite((String)properties.getProperty("target"), (URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public TargetSiteImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Policy.bind("TargetSiteImportWizard.Target_Site"));
    }

    public void addPages() {
        this.mainPage = new ImportTargetSiteMainPage("targetSiteMainPage", Policy.bind("TargetSiteImportWizard.Import_Target_Site"), TeamImages.getImageDescriptor("wizban/import_projectset_wizban.gif"));
        this.mainPage.setFileName(lastFile);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        block5: {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        InputStreamReader reader = null;
                        try {
                            try {
                                String filename;
                                lastFile = filename = TargetSiteImportWizard.this.mainPage.getFileName();
                                reader = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
                                SAXParserFactory factory = SAXParserFactory.newInstance();
                                SAXParser parser = factory.newSAXParser();
                                TargetSiteContentHandler handler = new TargetSiteContentHandler();
                                InputSource source = new InputSource(reader);
                                parser.parse(source, (DefaultHandler)handler);
                                Properties[] propList = handler.getProperties();
                                int i = 0;
                                while (i < propList.length) {
                                    String target = propList[i].getProperty("target");
                                    ISiteFactory siteFactory = TargetManager.getSiteFactory((String)target);
                                    Assert.isNotNull((Object)siteFactory);
                                    Site newsite = siteFactory.newSite(propList[i]);
                                    Site[] existingSites = TargetManager.getSites();
                                    boolean dupe = false;
                                    int j = 0;
                                    while (j < existingSites.length) {
                                        if (existingSites[j].equals((Object)newsite)) {
                                            dupe = true;
                                        }
                                        ++j;
                                    }
                                    if (!dupe) {
                                        TargetSiteImportWizard.this.getShell().getDisplay().syncExec(new Runnable(newsite){
                                            private final /* synthetic */ Site val$newsite;
                                            {
                                                this.val$newsite = site;
                                            }

                                            public void run() {
                                                TargetManager.addSite((Site)this.val$newsite);
                                            }
                                        });
                                    }
                                    ++i;
                                }
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (ParserConfigurationException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (SAXException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_20 = null;
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            throw throwable;
                        }
                        Object var16_21 = null;
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof TeamException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                    return false;
                }
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (!(target instanceof Error)) break block5;
                throw (Error)target;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

