/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.ProjectSetImportWizard;
import org.eclipse.team.internal.ui.target.ExportTargetSiteMainPage;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class TargetSiteExportWizard
extends Wizard
implements IExportWizard {
    private ExportTargetSiteMainPage mainPage;
    private IStructuredSelection selection;

    public TargetSiteExportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Policy.bind("TargetSiteExportWizard.Target_Site"));
    }

    public boolean performFinish() {
        boolean[] result;
        block5: {
            result = new boolean[1];
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        boolean r;
                        String filename = TargetSiteExportWizard.this.mainPage.getFileName();
                        Path path = new Path(filename);
                        if (path.getFileExtension() == null) {
                            filename = String.valueOf(filename) + ".tsf";
                        }
                        ProjectSetImportWizard.lastFile = filename;
                        File file = new File(filename);
                        File parentFile = file.getParentFile();
                        if (parentFile != null && !parentFile.exists()) {
                            r = MessageDialog.openQuestion((Shell)TargetSiteExportWizard.this.getShell(), (String)Policy.bind("TargetSiteExportWizard.Creation_Question"), (String)Policy.bind("TargetSiteExportWizard.Create_dir"));
                            if (!r) {
                                result[0] = false;
                                return;
                            }
                            r = parentFile.mkdirs();
                            if (!r) {
                                MessageDialog.openError((Shell)TargetSiteExportWizard.this.getShell(), (String)Policy.bind("TargetSiteExportWizard.Export_Problems"), (String)Policy.bind("TargetSiteExportWizard.Directory_creation_error"));
                                result[0] = false;
                                return;
                            }
                        }
                        if (file.exists() && file.isFile() && !(r = MessageDialog.openQuestion((Shell)TargetSiteExportWizard.this.getShell(), (String)Policy.bind("TargetSiteExportWizard.Overwrite_Question"), (String)Policy.bind("TargetSiteExportWizard.Overwrite_file")))) {
                            result[0] = false;
                            return;
                        }
                        BufferedWriter writer = null;
                        try {
                            try {
                                FileOutputStream jout = new FileOutputStream(file);
                                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)jout, "UTF-8"));
                                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                                writer.newLine();
                                writer.write("<tsf version=\"2.0\">");
                                writer.newLine();
                                writer.flush();
                                Site[] sites = TargetSiteExportWizard.this.mainPage.getSelectedSites();
                                monitor.beginTask(null, 5 * sites.length);
                                Properties props = sites[0].getConfiguration();
                                monitor.worked(2);
                                String target = sites[0].getType();
                                monitor.worked(1);
                                props.store(jout, "<site target=\"" + target + "\">");
                                monitor.worked(2);
                                int i = 1;
                                while (i < sites.length) {
                                    props = sites[i].getConfiguration();
                                    monitor.worked(2);
                                    target = sites[i].getType();
                                    monitor.worked(1);
                                    props.store(jout, "</site> <site target=\"" + target + "\">");
                                    monitor.worked(2);
                                    ++i;
                                }
                                jout.flush();
                                writer.write("</site>");
                                writer.newLine();
                                writer.write("</tsf>");
                                writer.newLine();
                                result[0] = true;
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_15 = null;
                            monitor.done();
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            throw throwable;
                        }
                        Object var12_16 = null;
                        monitor.done();
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof TeamException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                    return false;
                }
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (!(target instanceof Error)) break block5;
                throw (Error)target;
            }
        }
        return result[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.mainPage = new ExportTargetSiteMainPage("targetSiteMainPage", Policy.bind("TargetSiteExportWizard.Export_a_Target_Site"), TeamImages.getImageDescriptor("wizban/export_projectset_wizban.gif"));
        Site[] sites = this.selection.toList().toArray(new Site[0]);
        this.mainPage.setSelectedSites(sites);
        this.mainPage.setFileName(ProjectSetImportWizard.lastFile);
        this.addPage((IWizardPage)this.mainPage);
    }
}

