/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.target.RemoteResourceElement;
import org.eclipse.team.internal.ui.target.SiteElement;

public abstract class TargetAction
extends TeamAction {
    protected IRemoteTargetResource[] getSelectedRemoteFolders() {
        ArrayList<IRemoteTargetResource> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<IRemoteTargetResource>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next = elements.next();
                IRemoteTargetResource remote = null;
                if (next instanceof RemoteResourceElement) {
                    remote = ((RemoteResourceElement)next).getRemoteResource();
                } else if (next instanceof SiteElement) {
                    try {
                        remote = ((SiteElement)next).getSite().getRemoteResource();
                    }
                    catch (TeamException e) {
                        TeamUIPlugin.handle(e);
                        return new IRemoteTargetResource[0];
                    }
                }
                if (remote == null || !remote.isContainer()) continue;
                resources.add(remote);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            return resources.toArray(new IRemoteTargetResource[resources.size()]);
        }
        return new IRemoteTargetResource[0];
    }

    protected Site[] getSelectedSites() {
        ArrayList<Site> sites = new ArrayList<Site>();
        if (!this.selection.isEmpty()) {
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next = elements.next();
                if (!(next instanceof SiteElement)) continue;
                sites.add(((SiteElement)next).getSite());
            }
        }
        return sites.toArray(new Site[sites.size()]);
    }

    protected IResource[] findResourcesWithOutgoingChanges(IResource[] resources) throws TeamException, CoreException {
        final ArrayList dirtyResources = new ArrayList();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            final TargetProvider provider = TargetManager.getProvider((IProject)resource.getProject());
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 1 && (provider.isDirty(resource) || !provider.hasBase(resource))) {
                        dirtyResources.add(resource);
                    }
                    return true;
                }
            }, 2, true);
            ++i;
        }
        return dirtyResources.toArray(new IResource[dirtyResources.size()]);
    }
}

