/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.sync.SyncCompareInput;
import org.eclipse.team.internal.ui.sync.SyncView;
import org.eclipse.team.internal.ui.target.TargetSyncCompareInput;

public class SyncAction
extends TeamAction {
    public void run(IAction action) {
        IResource[] resources = this.getSelectedResources();
        SyncView view = SyncView.findViewInActivePage(this.getTargetPage());
        if (view != null) {
            view.showSync(this.getCompareInput(resources), this.getTargetPage());
        }
    }

    protected boolean isEnabled() throws TeamException {
        IResource[] resources = this.getSelectedResources();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isAccessible()) {
                return false;
            }
            TargetProvider provider = TargetManager.getProvider((IProject)resource.getProject());
            if (provider == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected SyncCompareInput getCompareInput(IResource[] resources) {
        return new TargetSyncCompareInput(resources, 1);
    }
}

