/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.core.target.UrlUtil;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.target.SiteElement;
import org.eclipse.team.internal.ui.target.SiteRootsElement;
import org.eclipse.team.internal.ui.target.TargetWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SiteSelectionPage
extends TargetWizardPage {
    private TableViewer table;
    private Button useExistingRepo;
    private Button useNewRepo;
    private Button disconnectTarget;
    private Site site;
    private TargetProvider currentProvider;
    private boolean disconnect = false;

    public SiteSelectionPage(String pageName, String title, ImageDescriptor titleImage, TargetProvider currentProvider) {
        super(pageName, title, titleImage);
        this.setDescription(Policy.bind("SiteSelectionPage.description"));
        this.currentProvider = currentProvider;
    }

    protected TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 68356);
        table.setLayoutData((Object)new GridData(1808));
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        table.setLayout((Layout)layout);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        return new TableViewer(table);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.ui.target_new_site_page_context");
        Label description = new Label(composite, 64);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 350;
        description.setLayoutData((Object)data);
        description.setText(Policy.bind("SiteSelectionPage.label"));
        this.useExistingRepo = this.createRadioButton(composite, Policy.bind("SiteSelectionPage.useExisting"), 2);
        this.table = this.createTable(composite);
        this.table.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                if (SiteSelectionPage.this.currentProvider != null && element.equals(new SiteElement(SiteSelectionPage.this.currentProvider.getSite()))) {
                    IPath mapping = UrlUtil.getTrailingPath((URL)SiteSelectionPage.this.currentProvider.getURL(), (URL)SiteSelectionPage.this.currentProvider.getSite().getURL());
                    if (mapping.isEmpty()) {
                        return Policy.bind("SiteSelectionPage.siteLabelCurrent", super.decorateText(input, element));
                    }
                    return Policy.bind("SiteSelectionPage.siteLabelCurrentWithMapping", super.decorateText(input, element), mapping.toString());
                }
                return super.decorateText(input, element);
            }
        });
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SiteElement siteElement = (SiteElement)((IStructuredSelection)SiteSelectionPage.this.table.getSelection()).getFirstElement();
                if (siteElement != null) {
                    SiteSelectionPage.this.site = siteElement.getSite();
                    SiteSelectionPage.this.setPageComplete(true);
                } else {
                    SiteSelectionPage.this.setPageComplete(false);
                }
            }
        });
        this.useNewRepo = this.createRadioButton(composite, Policy.bind("SiteSelectionPage.createNew"), 2);
        this.useExistingRepo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!SiteSelectionPage.this.useExistingRepo.getSelection()) {
                    SiteSelectionPage.this.table.getTable().setEnabled(false);
                    SiteSelectionPage.this.site = null;
                } else {
                    SiteSelectionPage.this.table.getTable().setEnabled(true);
                    SiteElement siteElement = (SiteElement)((IStructuredSelection)SiteSelectionPage.this.table.getSelection()).getFirstElement();
                    if (siteElement != null) {
                        SiteSelectionPage.this.site = siteElement.getSite();
                    }
                }
            }
        });
        this.useNewRepo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SiteSelectionPage.this.setPageComplete(!SiteSelectionPage.this.useNewRepo.getSelection());
            }
        });
        if (this.currentProvider != null) {
            this.disconnectTarget = this.createRadioButton(composite, Policy.bind("SiteSelectionPage.disconnectTarget"), 2);
            this.disconnectTarget.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SiteSelectionPage.this.disconnect = SiteSelectionPage.this.disconnectTarget.getSelection();
                    SiteSelectionPage.this.setPageComplete(true);
                }
            });
        }
        this.setControl((Control)composite);
        this.initializeValues();
    }

    private void initializeValues() {
        Site[] sites = TargetManager.getSites();
        this.table.setInput((Object)new SiteRootsElement(null));
        if (sites.length == 0) {
            this.useNewRepo.setSelection(true);
        } else {
            this.useExistingRepo.setSelection(true);
            if (this.currentProvider != null) {
                this.table.setSelection((ISelection)new StructuredSelection((Object)new SiteElement(this.currentProvider.getSite())));
            } else {
                this.table.setSelection((ISelection)new StructuredSelection((Object)new SiteElement(sites[0])));
            }
        }
    }

    public Site getSite() {
        return this.site;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public boolean canFlipToNextPage() {
        return !this.isDisconnect();
    }
}

