/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.target.RemoteResourceElement;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SiteExplorerViewLabelProvider
extends WorkbenchLabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return super.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return super.getText(element);
            }
            case 1: {
                if (element instanceof RemoteResourceElement) {
                    RemoteResourceElement remote = (RemoteResourceElement)element;
                    if (remote.getRemoteResource().isContainer()) {
                        return "";
                    }
                    int size = remote.getSize();
                    int sizeKb = size / 1000;
                    if (sizeKb == 0 && size % 1000 > 0) {
                        sizeKb = 1;
                    }
                    return Policy.bind("SiteExplorerViewLabelProvider.fileSize", new Integer(sizeKb).toString());
                }
            }
            case 2: {
                if (element instanceof RemoteResourceElement) {
                    return ((RemoteResourceElement)element).getLastModified();
                }
            }
            case 3: {
                if (!(element instanceof RemoteResourceElement)) break;
                return ((RemoteResourceElement)element).getRemoteResource().getURL().toExternalForm();
            }
        }
        return "";
    }
}

