/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.ISiteListener;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.target.ConfigureTargetWizard;
import org.eclipse.team.internal.ui.target.CreateNewFolderAction;
import org.eclipse.team.internal.ui.target.RemoteResourceElement;
import org.eclipse.team.internal.ui.target.SiteElement;
import org.eclipse.team.internal.ui.target.SiteExplorerViewLabelProvider;
import org.eclipse.team.internal.ui.target.SiteLazyContentProvider;
import org.eclipse.team.internal.ui.target.SiteRootsElement;
import org.eclipse.team.internal.ui.target.SiteViewSorter;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public class SiteExplorerView
extends ViewPart
implements ISiteListener {
    public static final String VIEW_ID = "org.eclipse.team.ui.target.SiteExplorerView";
    private TreeViewer folderTree;
    private TableViewer folderContentsTable;
    private SiteRootsElement root;
    private IProgressMonitor progressMonitorPart;
    private Action addSiteAction;
    private Action newFolderAction;
    private PropertyDialogAction propertiesAction;

    public void createPartControl(Composite top) {
        Composite p = new Composite(top, 0);
        GridData data = new GridData(1808);
        p.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        p.setLayout((Layout)gridLayout);
        SashForm sash = new SashForm(p, 256);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        sash.setLayoutData((Object)data);
        this.folderTree = new TreeViewer((Composite)sash, 770);
        this.folderTree.setContentProvider((IContentProvider)new SiteLazyContentProvider());
        this.folderTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.folderTree.setSorter((ViewerSorter)new SiteViewSorter());
        this.folderTree.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                RemoteResourceElement[] selectedFolders;
                if (event.keyCode == 0x100000E && (selectedFolders = SiteExplorerView.this.getSelectedRemoteFolder((IStructuredSelection)SiteExplorerView.this.folderTree.getSelection())).length == 1) {
                    selectedFolders[0].setCachedChildren(null);
                    SiteExplorerView.this.folderTree.refresh((Object)selectedFolders[0]);
                    SiteExplorerView.this.updateFileTable(selectedFolders[0]);
                }
            }
        });
        this.folderTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SiteExplorerView.this.folderTree.getSelection();
                RemoteResourceElement[] remoteFolders = SiteExplorerView.this.getSelectedRemoteFolder(selection);
                if (remoteFolders.length == 1) {
                    SiteExplorerView.this.updateFileTable(remoteFolders[0]);
                }
            }
        });
        this.folderTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SiteExplorerView.this.folderTree.getSelection();
                if (selection.size() == 1) {
                    SiteExplorerView.this.expandInTreeCurrentSelection(selection, true);
                }
            }
        });
        this.folderTree.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = "";
                String name2 = "";
                if (e1 instanceof RemoteResourceElement) {
                    name1 = ((RemoteResourceElement)e1).getRemoteResource().getName();
                } else if (e1 instanceof SiteElement) {
                    name1 = ((SiteElement)e1).getSite().getURL().toExternalForm();
                }
                if (e2 instanceof RemoteResourceElement) {
                    name2 = ((RemoteResourceElement)e2).getRemoteResource().getName();
                } else if (e2 instanceof SiteElement) {
                    name2 = ((SiteElement)e2).getSite().getURL().toExternalForm();
                }
                return this.getCollator().compare(name1, name2);
            }
        });
        this.folderTree.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof RemoteResourceElement) {
                    return ((RemoteResourceElement)element).getRemoteResource().isContainer();
                }
                return false;
            }
        });
        Table table = new Table((Composite)sash, 66304);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(Policy.bind("SiteExplorerView.Name_1"));
        tableColumn.addSelectionListener(this.getColumnListener());
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(Policy.bind("SiteExplorerView.Size_2"));
        tableColumn.setAlignment(131072);
        tableColumn.addSelectionListener(this.getColumnListener());
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(Policy.bind("SiteExplorerView.Modified_3"));
        tableColumn.addSelectionListener(this.getColumnListener());
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(Policy.bind("SiteExplorerView.URL_4"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        this.folderContentsTable = new TableViewer(table);
        this.folderContentsTable.setContentProvider((IContentProvider)new SiteLazyContentProvider());
        this.folderContentsTable.setLabelProvider((IBaseLabelProvider)new SiteExplorerViewLabelProvider());
        this.folderContentsTable.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                RemoteResourceElement folder;
                if (event.keyCode == 0x100000E && (folder = (RemoteResourceElement)SiteExplorerView.this.folderContentsTable.getInput()) != null) {
                    folder.setCachedChildren(null);
                    SiteExplorerView.this.folderContentsTable.refresh();
                }
            }
        });
        this.folderContentsTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                RemoteResourceElement[] remoteFolders;
                IStructuredSelection selection = (IStructuredSelection)SiteExplorerView.this.folderContentsTable.getSelection();
                if (selection.size() == 1 && (remoteFolders = SiteExplorerView.this.getSelectedRemoteFolder(selection)).length == 1) {
                    IStructuredSelection treeSelection = (IStructuredSelection)SiteExplorerView.this.folderTree.getSelection();
                    SiteExplorerView.this.expandInTreeCurrentSelection(treeSelection, false);
                    SiteExplorerView.this.folderTree.setSelection((ISelection)new StructuredSelection((Object)remoteFolders[0]));
                }
            }
        });
        FolderListingSorter sorter = new FolderListingSorter(0);
        sorter.setReversed(false);
        this.folderContentsTable.setSorter((ViewerSorter)sorter);
        sash.setWeights(new int[]{33, 67});
        TargetManager.addSiteListener((ISiteListener)this);
        this.root = new SiteRootsElement((IRunnableContext)this.getViewSite().getWorkbenchWindow());
        this.initalizeActions();
        this.folderTree.setInput((Object)this.root);
        WorkbenchHelp.setHelp((Control)this.folderTree.getControl(), (String)"org.eclipse.team.ui.site_explorer_view_context");
    }

    private Shell getShell() {
        return this.folderTree.getTree().getShell();
    }

    private RemoteResourceElement[] getSelectedRemoteFolder(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            ArrayList folders = new ArrayList();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof RemoteResourceElement)) continue;
                folders.add(o);
            }
            return folders.toArray(new RemoteResourceElement[folders.size()]);
        }
        return new RemoteResourceElement[0];
    }

    private void expandInTreeCurrentSelection(IStructuredSelection selection, boolean toggle) {
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (toggle) {
                    this.folderTree.setExpandedState(element, !this.folderTree.getExpandedState(element));
                    continue;
                }
                this.folderTree.setExpandedState(element, true);
            }
        }
    }

    private void updateFileTable(RemoteResourceElement remoteFolder) {
        if (remoteFolder != null && !remoteFolder.equals(this.folderContentsTable.getInput())) {
            this.folderContentsTable.setInput((Object)remoteFolder);
        }
    }

    private void initalizeActions() {
        final Shell shell = this.folderContentsTable.getTable().getShell();
        this.addSiteAction = new Action(Policy.bind("SiteExplorerView.addSiteAction"), TeamImages.getImageDescriptor("clcl16/site_element.gif")){

            public void run() {
                ConfigureTargetWizard wizard = new ConfigureTargetWizard();
                wizard.init(null, null);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
        };
        this.addSiteAction.setToolTipText(Policy.bind("SiteExplorerView.addSiteActionTooltip"));
        WorkbenchHelp.setHelp((IAction)this.addSiteAction, (String)"org.eclipse.team.ui.add_site_action_context");
        this.newFolderAction = new Action(Policy.bind("SiteExplorerView.newFolderAction"), WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_FOLDER")){

            public void run() {
                Shell shell = SiteExplorerView.this.folderTree.getTree().getShell();
                try {
                    IStructuredSelection selection = (IStructuredSelection)SiteExplorerView.this.folderTree.getSelection();
                    Object currentSelection = selection.getFirstElement();
                    RemoteResourceElement selectedFolder = !selection.isEmpty() ? SiteExplorerView.this.getSelectedRemoteFolder(selection)[0] : (RemoteResourceElement)SiteExplorerView.this.folderContentsTable.getInput();
                    IRemoteTargetResource newFolder = CreateNewFolderAction.createDir(shell, selectedFolder.getRemoteResource(), Policy.bind("CreateNewFolderAction.newFolderName"));
                    if (newFolder == null) {
                        return;
                    }
                    selectedFolder.setCachedChildren(null);
                    RemoteResourceElement newFolderUIElement = new RemoteResourceElement(newFolder);
                    SiteExplorerView.this.folderTree.refresh(currentSelection);
                    SiteExplorerView.this.expandInTreeCurrentSelection((IStructuredSelection)new StructuredSelection(currentSelection), false);
                    SiteExplorerView.this.folderTree.setSelection((ISelection)new StructuredSelection((Object)newFolderUIElement));
                }
                catch (TeamException e) {
                    TeamUIPlugin.handle(e);
                    return;
                }
            }

            public boolean isEnabled() {
                return SiteExplorerView.this.folderContentsTable.getInput() != null || SiteExplorerView.this.getSelectedRemoteFolder((IStructuredSelection)SiteExplorerView.this.folderTree.getSelection()).length == 1;
            }
        };
        WorkbenchHelp.setHelp((IAction)this.newFolderAction, (String)"org.eclipse.team.ui.new_folder_action_context");
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tbm = bars.getToolBarManager();
        tbm.add((IAction)this.addSiteAction);
        tbm.update(false);
        this.propertiesAction = new PropertyDialogAction(shell, (ISelectionProvider)this.folderTree);
        this.getViewSite().getActionBars().setGlobalActionHandler("properties", (IAction)this.propertiesAction);
        IStructuredSelection selection = (IStructuredSelection)this.folderTree.getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof SiteElement) {
            this.propertiesAction.setEnabled(true);
        } else {
            this.propertiesAction.setEnabled(false);
        }
        this.folderTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                boolean enabled = ss.size() == 1 && ss.getFirstElement() instanceof SiteElement;
                SiteExplorerView.this.propertiesAction.setEnabled(enabled);
            }
        });
        MenuManager treeMgr = new MenuManager();
        MenuManager tableMgr = new MenuManager();
        Tree tree = this.folderTree.getTree();
        Table table = this.folderContentsTable.getTable();
        Menu treeMenu = treeMgr.createContextMenu((Control)tree);
        Menu tableMenu = tableMgr.createContextMenu((Control)table);
        IMenuListener menuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager sub = new MenuManager(Policy.bind("SiteExplorerView.newMenu"), "group.add");
                sub.add((IContributionItem)new Separator("additions"));
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator("additions"));
                sub.add((IAction)SiteExplorerView.this.addSiteAction);
                sub.add((IAction)SiteExplorerView.this.newFolderAction);
                manager.add((IAction)SiteExplorerView.this.propertiesAction);
            }
        };
        treeMgr.addMenuListener(menuListener);
        treeMgr.setRemoveAllWhenShown(true);
        tableMgr.addMenuListener(menuListener);
        tableMgr.setRemoveAllWhenShown(true);
        tree.setMenu(treeMenu);
        table.setMenu(tableMenu);
        this.getSite().registerContextMenu(tableMgr, (ISelectionProvider)this.folderContentsTable);
        this.getSite().registerContextMenu(treeMgr, (ISelectionProvider)this.folderTree);
    }

    public void siteAdded(Site site) {
        SiteElement element = new SiteElement(site, (IRunnableContext)this.getViewSite().getWorkbenchWindow());
        this.folderTree.add((Object)this.root, (Object)element);
        this.folderTree.setSelection((ISelection)new StructuredSelection((Object)element));
    }

    public void siteRemoved(Site site) {
        this.folderTree.remove((Object)new SiteElement(site));
        this.selectNextObjectInTreeViewer();
    }

    private void selectNextObjectInTreeViewer() {
        Object[] items = this.folderTree.getVisibleExpandedElements();
        if (items.length > 0) {
            this.folderTree.setSelection((ISelection)new StructuredSelection(items[0]));
        } else {
            this.folderContentsTable.setInput(null);
        }
    }

    private SelectionListener getColumnListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = SiteExplorerView.this.folderContentsTable.getTable().indexOf((TableColumn)e.widget);
                if (column == 0) {
                    FolderListingSorter oldSorter = (FolderListingSorter)SiteExplorerView.this.folderContentsTable.getSorter();
                    if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                        oldSorter.setReversed(!oldSorter.isReversed());
                        SiteExplorerView.this.folderContentsTable.refresh();
                    } else {
                        SiteExplorerView.this.folderContentsTable.setSorter((ViewerSorter)new FolderListingSorter(column));
                    }
                }
            }
        };
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        TargetManager.removeSiteListener((ISiteListener)this);
    }

    class FolderListingSorter
    extends ViewerSorter {
        private boolean reversed = false;
        private int columnNumber;
        public static final int NAME = 0;
        public static final int SIZE = 1;
        public static final int MODIFIED = 2;
        private int[][] SORT_ORDERS_BY_COLUMN;

        public FolderListingSorter(int columnNumber) {
            int[][] nArrayArray = new int[3][];
            nArrayArray[0] = new int[1];
            int[] nArray = new int[2];
            nArray[0] = 1;
            nArrayArray[1] = nArray;
            int[] nArray2 = new int[3];
            nArray2[0] = 2;
            nArray2[2] = 1;
            nArrayArray[2] = nArray2;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            RemoteResourceElement e1 = (RemoteResourceElement)o1;
            RemoteResourceElement e2 = (RemoteResourceElement)o2;
            int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
            int result = 0;
            int i = 0;
            while (i < columnSortOrder.length) {
                result = this.compareColumnValue(columnSortOrder[i], e1, e2);
                if (result != 0) break;
                ++i;
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, RemoteResourceElement e1, RemoteResourceElement e2) {
            IRemoteTargetResource r1 = e1.getRemoteResource();
            IRemoteTargetResource r2 = e2.getRemoteResource();
            switch (columnNumber) {
                case 0: {
                    if (r1.isContainer() && r2.isContainer()) {
                        return this.compareNames(r1, r2);
                    }
                    if (r1.isContainer()) {
                        return -1;
                    }
                    if (r2.isContainer()) {
                        return 1;
                    }
                    return this.compareNames(r1, r2);
                }
                case 1: {
                    return new Integer(e1.getSize()).compareTo(new Integer(e2.getSize()));
                }
                case 2: {
                    return this.getCollator().compare(e1.getLastModified(), e2.getLastModified());
                }
            }
            return 0;
        }

        protected int compareNames(IRemoteTargetResource resource1, IRemoteTargetResource resource2) {
            return resource1.getName().compareTo(resource2.getName());
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }
}

