/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RemoteResourceElement
implements IWorkbenchAdapter,
IAdaptable {
    private IRemoteTargetResource remote;
    private IRemoteResource[] children = null;
    private int size = 0;
    private String lastModified = null;
    private IRunnableContext runContext;
    static /* synthetic */ Class class$0;

    public RemoteResourceElement(IRemoteTargetResource remote) {
        this.remote = remote;
    }

    public RemoteResourceElement(IRemoteTargetResource remote, IRunnableContext runContext) {
        this(remote);
        this.runContext = runContext;
    }

    public IRemoteTargetResource getRemoteResource() {
        return this.remote;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        final Object[][] result = new Object[1][];
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(null, -1);
                            if (RemoteResourceElement.this.children == null) {
                                RemoteResourceElement.this.setCachedChildren(RemoteResourceElement.this.remote.members(Policy.subMonitorFor(monitor, 50)));
                            }
                            ArrayList<RemoteResourceElement> remoteElements = new ArrayList<RemoteResourceElement>();
                            int i = 0;
                            while (i < RemoteResourceElement.this.children.length) {
                                IRemoteTargetResource child = (IRemoteTargetResource)RemoteResourceElement.this.children[i];
                                RemoteResourceElement element = new RemoteResourceElement(child, RemoteResourceElement.this.runContext);
                                element.setLastModified(child.getLastModified(Policy.subMonitorFor(monitor, 25)));
                                element.setSize(child.getSize(Policy.subMonitorFor(monitor, 25)));
                                remoteElements.add(element);
                                ++i;
                            }
                            result[0] = remoteElements.toArray(new RemoteResourceElement[remoteElements.size()]);
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var6_9 = null;
                    monitor.done();
                }
            };
            if (this.runContext == null) {
                TeamUIPlugin.runWithProgress(null, true, runnable);
            } else {
                this.runContext.run(true, true, runnable);
            }
        }
        catch (InterruptedException interruptedException) {
            return new Object[0];
        }
        catch (InvocationTargetException e) {
            TeamUIPlugin.handle(e.getTargetException());
            return new Object[0];
        }
        return result[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (this.remote.isContainer()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.remote.getName());
    }

    public String getLabel(Object o) {
        return this.remote.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public int hashCode() {
        return this.getRemoteResource().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RemoteResourceElement)) {
            return false;
        }
        return ((RemoteResourceElement)obj).getRemoteResource().equals(this.getRemoteResource());
    }

    public void clearChildren() {
        this.children = null;
    }

    public IRemoteResource[] getCachedChildren() {
        return this.children;
    }

    public void setCachedChildren(IRemoteResource[] children) {
        this.children = children;
    }

    protected void setRemoteResource(IRemoteTargetResource remote) {
        this.remote = remote;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public int getSize() {
        return this.size;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getName() {
        return this.remote.getName();
    }
}

