/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.core.target.UrlUtil;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.target.ConfigureTargetWizard;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectTargetMappingPropertiesPage
extends PropertyPage {
    public static final int WIDTH_HINT = 250;
    private IProject proj;
    private Site site = null;
    private IPath mapping;
    private TargetProvider origProvider = null;
    private Label serverText;
    private Label folderText;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label serverLabel = new Label(container, 0);
        serverLabel.setText(Policy.bind("ProjectTargetMappingPropertiesPage.URL"));
        this.serverText = new Label(container, 0);
        this.serverText.setText(this.site.getURL().toString());
        GridData data = new GridData();
        data.widthHint = 250;
        this.serverText.setLayoutData((Object)data);
        Label folderLabel = new Label(container, 0);
        folderLabel.setText(Policy.bind("ProjectTargetMappingPropertiesPage.FolderName"));
        this.folderText = new Label(container, 0);
        this.folderText.setText(this.mapping.toString());
        data = new GridData();
        data.widthHint = 250;
        this.folderText.setLayoutData((Object)data);
        Button change = new Button(container, 8);
        change.setText(Policy.bind("ProjectTargetMappingPropertiesPage.ChangeBtn"));
        change.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigureTargetWizard wizard = new ConfigureTargetWizard();
                wizard.init(null, ProjectTargetMappingPropertiesPage.this.proj);
                WizardDialog dialog = new WizardDialog(ProjectTargetMappingPropertiesPage.this.getShell(), (IWizard)wizard);
                dialog.open();
                ProjectTargetMappingPropertiesPage.this.refreshInfo();
            }
        });
        return container;
    }

    private void initialize() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            this.proj = ((IProject)element).getProject();
        } else {
            IProject adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IProject)element.getAdapter((Class)clazz)) != null) {
                this.proj = adapter.getProject();
            }
        }
        try {
            TargetProvider provider = TargetManager.getProvider((IProject)this.proj);
            if (this.origProvider == null) {
                this.origProvider = provider;
            }
            this.site = provider.getSite();
            this.mapping = UrlUtil.getTrailingPath((URL)provider.getURL(), (URL)this.site.getURL());
        }
        catch (TeamException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Policy.bind("ProjectTargetMappingPropertiesPage.Error"), null, (IStatus)e.getStatus());
        }
    }

    private void refreshInfo() {
        this.initialize();
        this.serverText.setText(this.site.getURL().toString());
        this.folderText.setText(this.mapping.toString());
    }

    protected void performDefaults() {
        super.performDefaults();
        IPath oldMapping = UrlUtil.getTrailingPath((URL)this.origProvider.getURL(), (URL)this.origProvider.getSite().getURL());
        try {
            TargetManager.unmap((IProject)this.proj);
            TargetManager.map((IProject)this.proj, (Site)this.origProvider.getSite(), (IPath)oldMapping);
        }
        catch (TeamException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Policy.bind("ProjectTargetMappingPropertiesPage.Error"), null, (IStatus)e.getStatus());
        }
        this.refreshInfo();
    }
}

