/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.UrlUtil;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.target.ConfigureTargetWizard;
import org.eclipse.team.internal.ui.target.CreateNewFolderAction;
import org.eclipse.team.internal.ui.target.RemoteResourceElement;
import org.eclipse.team.internal.ui.target.SiteElement;
import org.eclipse.team.internal.ui.target.SiteLazyContentProvider;
import org.eclipse.team.internal.ui.target.SiteRootsElement;
import org.eclipse.team.internal.ui.target.SiteViewSorter;
import org.eclipse.team.internal.ui.target.TargetWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class MappingSelectionPage
extends TargetWizardPage {
    private IPath path = Path.EMPTY;
    private Site site;
    private TreeViewer viewer;
    private Text textPath;

    public MappingSelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Policy.bind("MappingSelectionPage.description"));
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public Site getSite() {
        return this.site;
    }

    public void createControl(Composite p) {
        Composite composite = this.createComposite(p, 1);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.ui.target_mapping_selection_page_context");
        this.createLabel(composite, Policy.bind("MappingSelectionPage.label"));
        this.viewer = new TreeViewer(composite, 2052);
        GridData data = new GridData(1808);
        this.viewer.getTree().setLayoutData((Object)data);
        this.viewer.setContentProvider((IContentProvider)new SiteLazyContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setSorter((ViewerSorter)new SiteViewSorter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MappingSelectionPage.this.updateTextPath();
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof RemoteResourceElement) {
                    return ((RemoteResourceElement)element).getRemoteResource().isContainer();
                }
                return false;
            }
        });
        Button newFolderButton = new Button(composite, 8);
        newFolderButton.setText(Policy.bind("MappingSelectionPage.newFolderLabel"));
        newFolderButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MappingSelectionPage.this.getShell();
                try {
                    IStructuredSelection selection = (IStructuredSelection)MappingSelectionPage.this.viewer.getSelection();
                    Object currentSelection = selection.getFirstElement();
                    IRemoteTargetResource selectedFolder = MappingSelectionPage.this.getSelectedRemoteFolder(selection);
                    String defaultName = ((ConfigureTargetWizard)MappingSelectionPage.this.getWizard()).project.getName();
                    IRemoteTargetResource newFolder = CreateNewFolderAction.createDir(MappingSelectionPage.this.getShell(), selectedFolder, defaultName);
                    if (newFolder == null) {
                        return;
                    }
                    RemoteResourceElement newFolderUIElement = new RemoteResourceElement(newFolder);
                    ((RemoteResourceElement)currentSelection).setCachedChildren(null);
                    MappingSelectionPage.this.viewer.refresh(currentSelection);
                    MappingSelectionPage.this.viewer.setExpandedState(currentSelection, true);
                    MappingSelectionPage.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newFolderUIElement));
                }
                catch (TeamException e) {
                    TeamUIPlugin.handle(e);
                    return;
                }
            }
        });
        this.setViewerInput();
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    private IRemoteTargetResource getSelectedRemoteFolder(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            new ArrayList();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof RemoteResourceElement) {
                    return ((RemoteResourceElement)o).getRemoteResource();
                }
                if (!(o instanceof SiteElement)) continue;
                try {
                    return ((SiteElement)o).getSite().getRemoteResource();
                }
                catch (TeamException teamException) {
                    return null;
                }
            }
        }
        return null;
    }

    private void updateTextPath() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            new ArrayList();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof RemoteResourceElement)) continue;
                RemoteResourceElement element = (RemoteResourceElement)o;
                URL remoteResourceURL = element.getRemoteResource().getURL();
                this.path = UrlUtil.getTrailingPath((URL)remoteResourceURL, (URL)this.site.getURL());
                return;
            }
        }
    }

    public IPath getMapping() {
        return this.path;
    }

    private void setViewerInput() {
        if (this.site == null || this.viewer == null) {
            return;
        }
        this.viewer.setInput((Object)new SiteRootsElement(new Site[]{this.site}, (IRunnableContext)this.getContainer()));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setViewerInput();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)new SiteElement(this.site)));
        }
        super.setVisible(visible);
    }
}

