/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.io.File;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamWizardPage;

public class ImportTargetSiteMainPage
extends TeamWizardPage {
    private Text fileText;
    private String file = "";
    private Button browseButton;

    public ImportTargetSiteMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private void updateEnablement() {
        boolean complete;
        if (this.file.length() == 0) {
            this.setMessage(null);
            complete = false;
        } else {
            File f = new File(this.file);
            if (!f.exists()) {
                this.setMessage(Policy.bind("ImportTargetSiteMainPage.nonexistent_file"), 3);
                complete = false;
            } else if (f.isDirectory()) {
                this.setMessage(Policy.bind("ImportTargetSiteMainPage.folder_specified"), 3);
                complete = false;
            } else {
                complete = true;
            }
        }
        if (complete) {
            this.setMessage(null);
        }
        this.setPageComplete(complete);
    }

    public void setFileName(String file) {
        if (file != null) {
            this.file = file;
        }
    }

    public String getFileName() {
        return this.file;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileText.setFocus();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createLabel(inner, Policy.bind("ImportTargetSiteMainPage.File_name"));
        this.fileText = this.createTextField(inner);
        if (this.file != null) {
            this.fileText.setText(this.file);
        }
        this.fileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ImportTargetSiteMainPage.this.file = ImportTargetSiteMainPage.this.fileText.getText();
                ImportTargetSiteMainPage.this.updateEnablement();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(Policy.bind("ImportTargetSiteMainPage.Browse"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(ImportTargetSiteMainPage.this.getShell());
                d.setFilterExtensions(new String[]{"*.tsf", "*"});
                d.setFilterNames(new String[]{Policy.bind("ImportTargetSiteMainPage.Target_Site_Files"), Policy.bind("ImportTargetSiteMainPage.allFiles")});
                d.setFilterPath(new File(".").getAbsolutePath());
                String f = d.open();
                if (f != null) {
                    ImportTargetSiteMainPage.this.fileText.setText(f);
                    ImportTargetSiteMainPage.this.file = f;
                }
            }
        });
        this.setControl((Control)composite);
        this.updateEnablement();
    }
}

