/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.InfiniteSubProgressMonitor;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.target.TargetSyncAction;
import org.eclipse.team.internal.ui.target.TargetSyncCompareInput;
import org.eclipse.ui.help.WorkbenchHelp;

public class GetSyncAction
extends TargetSyncAction {
    public GetSyncAction(TargetSyncCompareInput model, ISelectionProvider sp, String label, Shell shell) {
        super(model, sp, label, shell);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.team.ui.sync_get_action_context");
    }

    protected boolean isEnabled(ITeamNode node) {
        SyncSet set = new SyncSet((IStructuredSelection)new StructuredSelection((Object)node));
        return set.hasIncomingChanges() || set.hasConflicts();
    }

    protected void removeNonApplicableNodes(SyncSet set, int syncMode) {
        set.removeOutgoingNodes();
    }

    protected SyncSet run(SyncSet syncSet, IProgressMonitor monitor) {
        try {
            ITeamNode[] changed = syncSet.getChangedNodes();
            if (changed.length == 0) {
                return syncSet;
            }
            ArrayList<IResource> fileResources = new ArrayList<IResource>();
            ArrayList<IResource> folderDeletions = new ArrayList<IResource>();
            ArrayList<IResource> folderAdditions = new ArrayList<IResource>();
            int i = 0;
            while (i < changed.length) {
                if (changed[i].getChangeDirection() == 8 || changed[i].getChangeDirection() == 12) {
                    if (changed[i].getResource().getType() == 1) {
                        fileResources.add(changed[i].getResource());
                    } else if (changed[i].getChangeType() == 2 && changed[i].getResource().exists()) {
                        folderDeletions.add(changed[i].getResource());
                    } else {
                        IResource resource = changed[i].getResource();
                        if (TargetSyncAction.getRemoteResourceFor(resource).members(monitor).length == 0) {
                            folderAdditions.add(changed[i].getResource());
                        }
                    }
                }
                ++i;
            }
            this.get(fileResources.toArray(new IResource[fileResources.size()]), monitor);
            this.get(folderAdditions.toArray(new IResource[folderDeletions.size()]), monitor);
            if (folderDeletions.size() > 0) {
                Iterator iter = folderDeletions.iterator();
                IContainer container = (IContainer)iter.next();
                while (iter.hasNext()) {
                    boolean delete = true;
                    IResource[] children = container.members();
                    int j = 0;
                    while (j < children.length) {
                        if (!folderDeletions.contains(children[j])) {
                            delete = false;
                            break;
                        }
                        ++j;
                    }
                    if (!delete) {
                        iter.remove();
                    }
                    container = (IContainer)iter.next();
                }
                this.get(folderDeletions.toArray(new IResource[folderDeletions.size()]), monitor);
            }
        }
        catch (TeamException e) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)GetSyncAction.this.getShell(), null, null, (IStatus)e.getStatus());
                }
            });
            return null;
        }
        catch (CoreException e) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)GetSyncAction.this.getShell(), null, null, (IStatus)e.getStatus());
                }
            });
            return null;
        }
        return syncSet;
    }

    public void get(IResource[] resources, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        try {
            Hashtable table = this.getTargetProviderMapping(resources);
            Set keySet = table.keySet();
            monitor.beginTask("", keySet.size() * 1000);
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                InfiniteSubProgressMonitor subMonitor = new InfiniteSubProgressMonitor(monitor, 1000);
                TargetProvider provider = (TargetProvider)iterator.next();
                monitor.setTaskName(Policy.bind("GetAction.working", provider.getURL().toExternalForm()));
                List list = (List)table.get(provider);
                IResource[] providerResources = list.toArray(new IResource[list.size()]);
                provider.get(providerResources, (IProgressMonitor)subMonitor);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
        Object var10_12 = null;
        monitor.done();
    }
}

