/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.core.target.UrlUtil;
import org.eclipse.team.internal.ui.IPromptCondition;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.PromptingDialog;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.target.TargetAction;

public class GetAsProjectAction
extends TargetAction {
    public void run(IAction action) {
        final IRemoteTargetResource[] remoteFolders = this.getSelectedRemoteFolders();
        HashSet<IProject> targetProjects = new HashSet<IProject>();
        int i = 0;
        while (i < remoteFolders.length) {
            String projectName = remoteFolders[i].getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            targetProjects.add(project);
            ++i;
        }
        final IResource[] projects = targetProjects.toArray(new IResource[targetProjects.size()]);
        PromptingDialog prompt = new PromptingDialog(this.getShell(), projects, this.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("GetAsProject.confirmOverwrite"));
        try {
            if (prompt.promptForMultiple().length != projects.length) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        try {
            TeamUIPlugin.runWithProgressDialog(this.getShell(), true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(GetAsProjectAction.getTaskName(remoteFolders), remoteFolders.length * 100);
                            monitor.setTaskName(GetAsProjectAction.getTaskName(remoteFolders));
                            int i = 0;
                            while (i < remoteFolders.length) {
                                IProject project = (IProject)projects[i];
                                IRemoteTargetResource remote = remoteFolders[i];
                                IProgressMonitor subMonitor = Policy.subInfiniteMonitorFor(monitor, 100);
                                GetAsProjectAction.this.get(project, remote, subMonitor);
                                ++i;
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var6_9 = null;
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            this.handle(e, Policy.bind("Error"), Policy.bind("GetAsProject.errorGettingResources"));
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected boolean isEnabled() throws TeamException {
        return this.getSelectedRemoteFolders().length > 0;
    }

    protected void get(IProject project, IRemoteTargetResource remote, IProgressMonitor monitor) throws TeamException {
        try {
            monitor.beginTask(null, 100);
            try {
                if (!project.exists()) {
                    project.create(Policy.subMonitorFor(monitor, 5));
                }
                if (!project.isOpen()) {
                    project.open(Policy.subMonitorFor(monitor, 5));
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Policy.bind("Error"), (String)Policy.bind("GetAsProject.errorCreatingProject"), (IStatus)e.getStatus());
                Object var6_6 = null;
                monitor.done();
                return;
            }
            Site site = remote.getSite();
            TargetProvider provider = TargetManager.getProvider((IProject)project);
            if (provider != null) {
                TargetManager.unmap((IProject)project);
            }
            TargetManager.map((IProject)project, (Site)site, (IPath)UrlUtil.getTrailingPath((URL)remote.getURL(), (URL)site.getURL()));
            provider = TargetManager.getProvider((IProject)project);
            provider.get((IResource)project, remote, Policy.subMonitorFor(monitor, 90));
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        Object var6_8 = null;
        monitor.done();
    }

    protected static String getTaskName(IRemoteTargetResource[] remoteFolders) {
        if (remoteFolders.length == 1) {
            IRemoteTargetResource folder = remoteFolders[0];
            return Policy.bind("GetAsProject.taskName1", folder.getURL().toExternalForm());
        }
        return Policy.bind("GetAsProject.taskNameN", new Integer(remoteFolders.length).toString());
    }

    protected IPromptCondition getOverwriteLocalAndFileSystemPrompt() {
        return new IPromptCondition(){

            public boolean needsPrompt(IResource resource) {
                File localLocation = this.getFileLocation(resource);
                return resource.exists() || localLocation.exists();
            }

            public String promptMessage(IResource resource) {
                this.getFileLocation(resource);
                if (resource.exists()) {
                    return Policy.bind("GetAsProject.thisResourceExists", resource.getName());
                }
                return Policy.bind("GetAsProject.thisExternalFileExists", resource.getName());
            }

            private File getFileLocation(IResource resource) {
                return new File(resource.getParent().getLocation().toFile(), resource.getName());
            }
        };
    }
}

