/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.PromptingDialog;
import org.eclipse.team.internal.ui.target.GetAsProjectAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ProjectLocationSelectionDialog;

public class GetAsAction
extends GetAsProjectAction {
    public void run(IAction action) {
        IRemoteTargetResource[] folders = this.getSelectedRemoteFolders();
        if (folders.length != 1) {
            return;
        }
        final IRemoteTargetResource remoteFolder = folders[0];
        final String remoteName = remoteFolder.getName();
        final boolean[] hasProjectMetaFile = new boolean[1];
        boolean[] errorOccured = new boolean[1];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    hasProjectMetaFile[0] = GetAsAction.this.hasProjectMetaFile(remoteFolder, monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, Policy.bind("GetAs.checkoutFailed"), 1);
        if (errorOccured[0]) {
            return;
        }
        IProject newProject = null;
        if (!hasProjectMetaFile[0] && (newProject = this.getNewProject(remoteFolder.getName())) == null) {
            return;
        }
        final IProject createdProject = newProject;
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                try {
                                    try {
                                        IProject project;
                                        if (hasProjectMetaFile[0]) {
                                            Shell shell = GetAsAction.this.getShell();
                                            int[] result = new int[1];
                                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(remoteName);
                                            ProjectLocationSelectionDialog dialog = new ProjectLocationSelectionDialog(shell, project);
                                            dialog.setTitle(Policy.bind("GetAs.enterProjectTitle", remoteName));
                                            shell.getDisplay().syncExec(new Runnable(result, dialog){
                                                private final /* synthetic */ int[] val$result;
                                                private final /* synthetic */ ProjectLocationSelectionDialog val$dialog;
                                                {
                                                    this.val$result = nArray;
                                                    this.val$dialog = projectLocationSelectionDialog;
                                                }

                                                public void run() {
                                                    this.val$result[0] = this.val$dialog.open();
                                                }
                                            });
                                            if (result[0] != 0) {
                                                Object var11_7 = null;
                                                break block12;
                                            }
                                            Object[] destinationPaths = dialog.getResult();
                                            if (destinationPaths == null) {
                                                break block13;
                                            }
                                            String newName = (String)destinationPaths[0];
                                            Path newLocation = new Path((String)destinationPaths[1]);
                                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(newName);
                                            PromptingDialog prompt = new PromptingDialog(GetAsAction.this.getShell(), new IResource[]{project}, GetAsAction.this.getOverwriteLocalAndFileSystemPrompt(), Policy.bind("GetAsProject.confirmOverwrite"));
                                            if (prompt.promptForMultiple().length == 0) {
                                                break block14;
                                            }
                                            monitor.beginTask(null, 100);
                                            monitor.setTaskName(Policy.bind("GetAs.taskname", remoteFolder.getName(), newName));
                                            try {
                                                if (newLocation.equals((Object)Platform.getLocation())) {
                                                    project.create(Policy.subMonitorFor(monitor, 3));
                                                } else {
                                                    IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
                                                    desc.setLocation((IPath)newLocation);
                                                    project.create(desc, Policy.subMonitorFor(monitor, 3));
                                                }
                                                project.open(Policy.subMonitorFor(monitor, 2));
                                            }
                                            catch (CoreException e) {
                                                throw new TeamException(e.getStatus());
                                            }
                                        }
                                        project = createdProject;
                                        monitor.beginTask(null, 95);
                                        monitor.setTaskName(Policy.bind("GetAs.taskname", remoteFolder.getName(), createdProject.getName()));
                                        GetAsAction.this.get(project, remoteFolder, Policy.subInfiniteMonitorFor(monitor, 95));
                                        break block15;
                                    }
                                    catch (TeamException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var11_10 = null;
                                    monitor.done();
                                    throw throwable;
                                }
                            }
                            monitor.done();
                            return;
                        }
                        Object var11_8 = null;
                        monitor.done();
                        return;
                    }
                    Object var11_9 = null;
                    monitor.done();
                    return;
                }
                Object var11_11 = null;
                monitor.done();
            }
        }, Policy.bind("GetAs.checkoutFailed"), 1);
    }

    protected boolean isEnabled() throws TeamException {
        return this.getSelectedRemoteFolders().length == 1;
    }

    private IProject getNewProject(String suggestedName) {
        NewProjectListener listener = new NewProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        return listener.getNewProject();
    }

    protected boolean hasProjectMetaFile(IRemoteTargetResource remote, IProgressMonitor monitor) throws TeamException {
        IRemoteResource[] children = remote.members(monitor);
        int i = 0;
        while (i < children.length) {
            if (children[i].getName().equals(".project")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

