/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.DetailsDialog;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.target.TargetAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GetAction
extends TargetAction {
    public void run(IAction action) {
        if (this.promptForOutgoingChanges()) {
            this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                    try {
                        try {
                            Hashtable table = GetAction.this.getTargetProviderMapping();
                            Set keySet = table.keySet();
                            monitor.beginTask(null, keySet.size() * 1000);
                            Iterator iterator = keySet.iterator();
                            while (iterator.hasNext()) {
                                TargetProvider provider = (TargetProvider)iterator.next();
                                monitor.setTaskName(Policy.bind("GetAction.working", provider.getURL().toExternalForm()));
                                List list = (List)table.get(provider);
                                IResource[] providerResources = list.toArray(new IResource[list.size()]);
                                provider.get(providerResources, Policy.subInfiniteMonitorFor(monitor, 1000));
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var8_11 = null;
                    monitor.done();
                }
            }, Policy.bind("GetAction.title"), 1);
        }
    }

    private boolean promptForOutgoingChanges() {
        try {
            Hashtable table = this.getTargetProviderMapping();
            Set keySet = table.keySet();
            Iterator iterator = keySet.iterator();
            ArrayList<IResource> outgoingChanges = new ArrayList<IResource>();
            while (iterator.hasNext()) {
                TargetProvider provider = (TargetProvider)iterator.next();
                List list = (List)table.get(provider);
                IResource[] providerResources = list.toArray(new IResource[list.size()]);
                outgoingChanges.addAll(Arrays.asList(this.findResourcesWithOutgoingChanges(providerResources)));
            }
            if (!outgoingChanges.isEmpty()) {
                final OutgoingChangesDialog dialog = new OutgoingChangesDialog(this.getShell(), outgoingChanges.toArray(new IResource[outgoingChanges.size()]));
                final boolean[] okToContinue = new boolean[]{true};
                this.getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (dialog.open() != 0) {
                            okToContinue[0] = false;
                        }
                    }
                });
                return okToContinue[0];
            }
            return true;
        }
        catch (CoreException e) {
            TeamUIPlugin.handle(e);
        }
        catch (TeamException e) {
            TeamUIPlugin.handle(e);
        }
        return false;
    }

    protected boolean isEnabled() throws TeamException {
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            TargetProvider provider = TargetManager.getProvider((IProject)resource.getProject());
            if (provider == null) {
                return false;
            }
            if (!provider.canPut(resource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class OutgoingChangesDialog
    extends DetailsDialog {
        private IResource[] outgoingChanges;
        private org.eclipse.swt.widgets.List detailsList;

        public OutgoingChangesDialog(Shell shell, IResource[] outgoingChanges) {
            super(shell, Policy.bind("GetAction.confirmFileOverwriteTitle"));
            this.setImageKey("dialog_question_image");
            this.outgoingChanges = outgoingChanges;
        }

        protected Composite createDropDownDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setFont(parent.getFont());
            this.detailsList = new org.eclipse.swt.widgets.List(composite, 2818);
            GridData data = new GridData();
            data.heightHint = 75;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.detailsList.setLayoutData((Object)data);
            int i = 0;
            while (i < this.outgoingChanges.length) {
                this.detailsList.add(this.outgoingChanges[i].getFullPath().toString());
                ++i;
            }
            return composite;
        }

        protected void createMainDialogArea(Composite parent) {
            Label label = new Label(parent, 64);
            label.setText(Policy.bind("GetAction.confirmFileOverwrite"));
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.setPageComplete(true);
        }

        protected void updateEnablements() {
        }
    }
}

