/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamWizardPage;

public class ExportTargetSiteMainPage
extends TeamWizardPage {
    private List selectedSites = new ArrayList();
    private Text fileText;
    private String fileName = "";
    private Table table;
    private Button browseButton;

    public ExportTargetSiteMainPage(String pageName) {
        super(pageName);
    }

    public ExportTargetSiteMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        this.createLabel(composite, Policy.bind("ExportTargetSiteMainPage.Select_Sites"));
        this.table = new Table(composite, 2848);
        this.table.setLayout((Layout)new TableLayout());
        GridData data = new GridData(1808);
        data.heightHint = 300;
        this.table.setLayoutData((Object)data);
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem item = (TableItem)event.item;
                    if (item.getChecked()) {
                        ExportTargetSiteMainPage.this.selectedSites.add(item.getData());
                    } else {
                        ExportTargetSiteMainPage.this.selectedSites.remove(item.getData());
                    }
                    ExportTargetSiteMainPage.this.updateEnablement();
                }
            }
        });
        this.createLabel(composite, Policy.bind("ExportTargetSiteMainPage.Target_Site_Filename"));
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createLabel(inner, Policy.bind("ExportTargetSiteMainPage.File_name"));
        this.fileText = this.createTextField(inner);
        if (this.fileName != null) {
            this.fileText.setText(this.fileName);
        }
        this.fileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ExportTargetSiteMainPage.this.fileName = ExportTargetSiteMainPage.this.fileText.getText();
                ExportTargetSiteMainPage.this.updateEnablement();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(Policy.bind("ExportTargetSiteMainPage.Browse"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(ExportTargetSiteMainPage.this.getShell(), 8192);
                d.setFilterExtensions(new String[]{"*.tsf"});
                d.setFilterNames(new String[]{Policy.bind("ExportTargetSiteMainPage.Target_Site_Files")});
                d.setFileName(Policy.bind("ExportTargetSiteMainPage.default"));
                d.setFilterPath(new File(".").getAbsolutePath());
                String f = d.open();
                if (f != null) {
                    ExportTargetSiteMainPage.this.fileText.setText(f);
                    ExportTargetSiteMainPage.this.fileName = f;
                }
            }
        });
        this.initializeSites();
        this.setControl((Control)composite);
        this.updateEnablement();
    }

    public void setSelectedSites(Site[] selectedSites) {
        this.selectedSites.addAll(Arrays.asList(selectedSites));
    }

    public void setFileName(String file) {
        if (file != null) {
            this.fileName = file;
        }
    }

    private void initializeSites() {
        new ArrayList();
        Site[] workspaceSites = TargetManager.getSites();
        int i = 0;
        while (i < workspaceSites.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)workspaceSites[i]);
            item.setText(workspaceSites[i].getDisplayName());
            ++i;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public Site[] getSelectedSites() {
        return this.selectedSites.toArray(new Site[this.selectedSites.size()]);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileText.setFocus();
        }
    }

    private void updateEnablement() {
        boolean complete;
        if (this.selectedSites.size() == 0) {
            this.setMessage(null);
            complete = false;
        } else if (this.fileName.length() == 0) {
            this.setMessage(null);
            complete = false;
        } else {
            File f = new File(this.fileName);
            if (f.isDirectory()) {
                this.setMessage(Policy.bind("ExportTargetSiteMainPage.folder_specified"), 3);
                complete = false;
            } else {
                complete = true;
            }
        }
        if (complete) {
            this.setMessage(null);
        }
        this.setPageComplete(complete);
    }
}

