/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.DetailsDialog;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.target.TargetAction;

public class DiscardSiteAction
extends TargetAction {
    protected boolean isEnabled() throws TeamException {
        return this.getSelectedSites().length > 0;
    }

    public void run(IAction action) {
        this.deletedSelected();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deletedSelected() {
        try {
            Site[] sites = this.getSelectedSites();
            if (sites.length <= 0) return;
            IProject[] mappedProjects = this.projectsMappedToSite(sites);
            if (mappedProjects.length > 0) {
                AlreadyMappedDialog dialog = new AlreadyMappedDialog(this.getShell(), mappedProjects);
                if (dialog.open() != 0) return;
                int i = 0;
                while (i < mappedProjects.length) {
                    TargetManager.unmap((IProject)mappedProjects[i]);
                    ++i;
                }
            } else {
                MessageDialog d = new MessageDialog(this.getShell(), Policy.bind("SiteExplorerView.promptForDeletingSitesTitle"), null, Policy.bind("SiteExplorerView.promptForDeletingSites", new Integer(sites.length).toString()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                if (d.open() != 0) {
                    return;
                }
            }
            int i = 0;
            while (i < sites.length) {
                TargetManager.removeSite((Site)sites[i]);
                sites[i].dispose();
                ++i;
            }
            return;
        }
        catch (TeamException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Policy.bind("Error"), (String)Policy.bind("CreateNewFolderAction.errorDeletingSites"), (IStatus)e.getStatus());
        }
    }

    private IProject[] projectsMappedToSite(Site[] sites) throws TeamException {
        ArrayList<IProject> mappedProjects = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            TargetProvider target = TargetManager.getProvider((IProject)project);
            int j = 0;
            while (j < sites.length) {
                if (target != null && target.getSite().equals((Object)sites[j])) {
                    mappedProjects.add(project);
                }
                ++j;
            }
            ++i;
        }
        return mappedProjects.toArray(new IProject[mappedProjects.size()]);
    }

    private class AlreadyMappedDialog
    extends DetailsDialog {
        private IProject[] projects;
        private List detailsList;
        private Button unmap;

        public AlreadyMappedDialog(Shell shell, IProject[] projects) {
            super(shell, Policy.bind("SiteExplorerView.unmapDialogTitle"));
            this.setImageKey("dialog_warning_image");
            this.projects = projects;
        }

        protected Composite createDropDownDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setFont(parent.getFont());
            this.detailsList = new List(composite, 2818);
            GridData data = new GridData();
            data.heightHint = 75;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.detailsList.setLayoutData((Object)data);
            int i = 0;
            while (i < this.projects.length) {
                block3: {
                    TargetProvider target;
                    IProject project = this.projects[i];
                    try {
                        target = TargetManager.getProvider((IProject)project);
                    }
                    catch (TeamException teamException) {
                        break block3;
                    }
                    this.detailsList.add(Policy.bind("SiteExplorerView.mappedProjects", project.getName(), target.getURL().toExternalForm()));
                }
                ++i;
            }
            return composite;
        }

        protected void createMainDialogArea(Composite composite) {
            Label label = new Label(composite, 64);
            label.setText(Policy.bind("SiteExplorerView.projectsAlreadyMapped"));
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(composite.getFont());
            this.unmap = new Button(composite, 32);
            this.unmap.setText(Policy.bind("SiteExplorerView.unmapProjectsAndDisconnect"));
            this.unmap.setSelection(false);
            this.unmap.addListener(13, new Listener(this){
                private final /* synthetic */ AlreadyMappedDialog this$1;
                {
                    this.this$1 = alreadyMappedDialog;
                }

                public void handleEvent(Event event) {
                    this.this$1.updateEnablements();
                }
            });
            this.setPageComplete(false);
            this.updateEnablements();
        }

        protected void updateEnablements() {
            this.setPageComplete(this.unmap.getSelection());
        }
    }
}

