/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.target.TargetAction;

public class CreateNewFolderAction
extends TargetAction {
    protected boolean isEnabled() throws TeamException {
        return this.getSelectedRemoteFolders().length == 1;
    }

    public void run(IAction action) {
        try {
            TeamUIPlugin.runWithProgressDialog(this.getShell(), true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CreateNewFolderAction.createDir(CreateNewFolderAction.this.getShell(), CreateNewFolderAction.this.getSelectedRemoteFolders()[0], new String());
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.handle(e, Policy.bind("Error"), Policy.bind("CreateNewFolderAction.errorCreatingFolder"));
        }
        catch (InterruptedException interruptedException) {}
    }

    public static IRemoteTargetResource createDir(final Shell shell, final IRemoteTargetResource parent, final String defaultName) throws TeamException {
        final IRemoteTargetResource[] newFolder = new IRemoteTargetResource[1];
        try {
            TeamUIPlugin.runWithProgressDialog(shell, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(Policy.bind("CreateNewFolderAction.creatingFolder"), -1);
                            String[] folderName = new String[1];
                            String suggestedName = CreateNewFolderAction.getSuggestedFolderName(parent, Policy.subMonitorFor(monitor, 0), defaultName);
                            shell.getDisplay().syncExec(new Runnable(shell, suggestedName, monitor, folderName){
                                private final /* synthetic */ Shell val$shell;
                                private final /* synthetic */ String val$suggestedName;
                                private final /* synthetic */ IProgressMonitor val$monitor;
                                private final /* synthetic */ String[] val$folderName;
                                {
                                    this.val$shell = shell;
                                    this.val$suggestedName = string;
                                    this.val$monitor = iProgressMonitor;
                                    this.val$folderName = stringArray;
                                }

                                public void run() {
                                    InputDialog dialog = new InputDialog(this.val$shell, Policy.bind("CreateNewFolderAction.title"), Policy.bind("CreateNewFolderAction.message"), this.val$suggestedName, null);
                                    Policy.checkCanceled(this.val$monitor);
                                    if (dialog.open() == 0) {
                                        this.val$folderName[0] = dialog.getValue();
                                    }
                                }
                            });
                            if (folderName[0] != null) {
                                newFolder[0] = parent.getFolder(folderName[0]);
                                newFolder[0].mkdirs(Policy.subMonitorFor(monitor, 0));
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var4_7 = null;
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof TeamException) {
                throw (TeamException)e.getTargetException();
            }
            TeamUIPlugin.handle(e);
        }
        catch (InterruptedException interruptedException) {}
        return newFolder[0];
    }

    protected static String getSuggestedFolderName(IRemoteTargetResource parent, IProgressMonitor monitor, String defaultName) throws TeamException {
        monitor.subTask(Policy.bind("CreateNewFolderAction.suggestedNameProgress"));
        IRemoteResource[] members = parent.members(monitor);
        ArrayList<String> names = new ArrayList<String>();
        String suggestedFolderName = defaultName;
        boolean nameUsed = false;
        int i = 0;
        while (i < members.length) {
            String existingName = members[i].getName();
            names.add(existingName);
            if (existingName.equals(suggestedFolderName)) {
                nameUsed = true;
            }
            ++i;
        }
        if (!nameUsed) {
            return suggestedFolderName;
        }
        int postfix = 1;
        String baseName = suggestedFolderName;
        do {
            nameUsed = false;
            int i2 = 0;
            while (i2 < members.length && !nameUsed) {
                suggestedFolderName = Policy.bind("CreateNewFolderAction.suggestedNameConcat", baseName, String.valueOf(postfix));
                String existingName = (String)names.get(i2);
                if (existingName.equals(suggestedFolderName)) {
                    ++postfix;
                    nameUsed = true;
                }
                ++i2;
            }
        } while (nameUsed);
        return suggestedFolderName;
    }
}

