/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.target;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.target.IRemoteTargetResource;
import org.eclipse.team.internal.core.target.Site;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.ConfigurationWizardElement;
import org.eclipse.team.internal.ui.ConfigureProjectWizardMainPage;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.target.MappingSelectionPage;
import org.eclipse.team.internal.ui.target.SiteSelectionPage;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.model.AdaptableList;

public class ConfigureTargetWizard
extends Wizard
implements IConfigurationWizard {
    protected IWorkbench workbench;
    protected IProject project;
    protected IConfigurationWizard wizard;
    protected ConfigureProjectWizardMainPage mainPage;
    protected static MappingSelectionPage mappingPage;
    private String pluginId = "org.eclipse.team.ui";
    protected static final String TAG_WIZARD = "wizard";
    protected static final String TAG_DESCRIPTION = "description";
    protected static final String ATT_NAME = "name";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_ICON = "icon";
    protected static final String ATT_ID = "id";
    public static final String MAPPING_PAGE_NAME = "mapping-page";
    protected SiteSelectionPage siteSelectionPage = null;

    public ConfigureTargetWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.getWizardWindowTitle());
    }

    protected String getExtensionPoint() {
        return "targetConfigWizards";
    }

    protected String getWizardDescription() {
        return Policy.bind("TargetSiteCreationWizard.description");
    }

    protected String getWizardLabel() {
        return Policy.bind("TargetSiteCreationWizard.label");
    }

    protected String getWizardWindowTitle() {
        if (this.project != null) {
            return Policy.bind("TargetSiteCreationWizard.windowTitleProject");
        }
        return Policy.bind("TargetSiteCreationWizard.windowTitleNoProject");
    }

    public void addPages() {
        Site[] sites = TargetManager.getSites();
        AdaptableList wizards = this.getAvailableWizards();
        if (sites.length > 0 && this.project != null) {
            TargetProvider provider = null;
            try {
                provider = TargetManager.getProvider((IProject)this.project);
            }
            catch (TeamException e) {
                TeamUIPlugin.log(e.getStatus());
            }
            this.siteSelectionPage = new SiteSelectionPage("site-selection-page", Policy.bind("TargetSiteCreationWizard.siteSelectionPage"), TeamImages.getImageDescriptor("wizban/share_wizban.gif"), provider);
            this.addPage((IWizardPage)this.siteSelectionPage);
        }
        if (this.project != null) {
            mappingPage = new MappingSelectionPage(MAPPING_PAGE_NAME, Policy.bind("MappingSelectionPage.mappingTitle"), TeamImages.getImageDescriptor("wizban/share_wizban.gif"));
            mappingPage.setWizard(this);
        }
        try {
            if (wizards.size() == 1) {
                ConfigurationWizardElement element = (ConfigurationWizardElement)((Object)wizards.getChildren()[0]);
                this.wizard = (IConfigurationWizard)element.createExecutableExtension();
                this.wizard.init(this.workbench, this.project);
                this.wizard.addPages();
                if (this.wizard.getPageCount() > 0) {
                    this.wizard.setContainer(this.getContainer());
                    IWizardPage[] pages = this.wizard.getPages();
                    int i = 0;
                    while (i < pages.length) {
                        this.addPage(pages[i]);
                        ++i;
                    }
                }
            } else {
                this.mainPage = new ConfigureProjectWizardMainPage("target-selection-page", this.getWizardLabel(), TeamImages.getImageDescriptor("wizban/share_wizban.gif"), wizards, Policy.bind("ConfigureProjectWizardMainPage.selectTarget"));
                this.mainPage.setDescription(this.getWizardDescription());
                this.mainPage.setProject(this.project);
                this.mainPage.setWorkbench(this.workbench);
                this.addPage((IWizardPage)this.mainPage);
            }
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e.getStatus());
            return;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.siteSelectionPage) {
            if (this.siteSelectionPage.isDisconnect()) {
                return null;
            }
            if (this.siteSelectionPage.getSite() != null) {
                mappingPage.setSite(this.siteSelectionPage.getSite());
                mappingPage.setPreviousPage(page);
                return mappingPage;
            }
            if (this.mainPage != null) {
                return this.mainPage;
            }
            if (this.wizard != null) {
                return this.wizard.getStartingPage();
            }
        }
        if (this.wizard != null) {
            return this.wizard.getNextPage(page);
        }
        return super.getNextPage(page);
    }

    public static MappingSelectionPage getMappingPage() {
        return mappingPage;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.mainPage) {
            return this.mainPage.getSelectedWizard() != null && this.mainPage.getNextPage() == null;
        }
        if (currentPage == this.siteSelectionPage) {
            return this.siteSelectionPage.getSite() != null || this.siteSelectionPage.isDisconnect();
        }
        MappingSelectionPage mappingPage = ConfigureTargetWizard.getMappingPage();
        if (mappingPage != null && currentPage == mappingPage) {
            return mappingPage.isPageComplete();
        }
        if (this.wizard != null) {
            return this.wizard.canFinish();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.siteSelectionPage || currentPage == ConfigureTargetWizard.getMappingPage()) {
            Site site;
            if (currentPage == this.siteSelectionPage) {
                if (this.siteSelectionPage.isDisconnect()) {
                    try {
                        TargetManager.unmap((IProject)this.project);
                    }
                    catch (TeamException e) {
                        ErrorDialog.openError((Shell)this.getShell(), (String)Policy.bind("Error"), (String)Policy.bind("ConfigureTargetWizard.errorUnmappingProject"), (IStatus)e.getStatus());
                        return false;
                    }
                    return true;
                }
                site = this.siteSelectionPage.getSite();
            } else {
                site = ConfigureTargetWizard.getMappingPage().getSite();
            }
            Path path = Path.EMPTY;
            if (ConfigureTargetWizard.getMappingPage() != null) {
                path = ConfigureTargetWizard.getMappingPage().getMapping();
            }
            if (!ConfigureTargetWizard.setMapping(this.getContainer(), this.project, site, (IPath)path)) {
                return false;
            }
        }
        if (this.wizard != null) {
            return this.wizard.performFinish();
        }
        return true;
    }

    public static boolean setMapping(IWizardContainer container, IProject project, Site site, IPath path) {
        if (ConfigureTargetWizard.validateSite(site, container)) {
            if (TargetManager.getSite((String)site.getType(), (URL)site.getURL()) == null) {
                TargetManager.addSite((Site)site);
            }
            try {
                TargetProvider provider = TargetManager.getProvider((IProject)project);
                if (provider != null) {
                    if (!provider.getSite().equals((Object)site) && !MessageDialog.openQuestion((Shell)container.getShell(), (String)Policy.bind("ConfigureTargetWizardQuestion_2"), (String)Policy.bind("ConfigureTargetWizard.alreadyMapped", project.getName(), provider.getURL().toExternalForm()))) {
                        return false;
                    }
                    TargetManager.unmap((IProject)project);
                }
                TargetManager.map((IProject)project, (Site)site, (IPath)path);
                return true;
            }
            catch (TeamException e) {
                ErrorDialog.openError((Shell)container.getShell(), (String)Policy.bind("ConfigureTargetWizardError_6"), (String)Policy.bind("ConfigureTargetWizardError_mapping_the_project_with_this_site_7"), (IStatus)e.getStatus());
                return false;
            }
        }
        return false;
    }

    public static boolean validateSite(final Site site, IWizardContainer container) {
        final boolean[] valid = new boolean[]{true};
        final String[] message = new String[]{Policy.bind("ConfigureTargetWizardURL_doesn__t_exist_on_the_server_8")};
        final int[] code = new int[]{-1};
        try {
            container.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(Policy.bind("ConfigureTargetWizardValidating_connection_to_Site..._9"), -1);
                            IRemoteTargetResource remote = site.getRemoteResource();
                            valid[0] = remote.canBeReached(monitor);
                        }
                        catch (TeamException e) {
                            message[0] = e.getStatus().getMessage();
                            code[0] = e.getStatus().getCode();
                            valid[0] = false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    Object var3_6 = null;
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            valid[0] = false;
            message[0] = e.getTargetException().getMessage();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return valid[0] || MessageDialog.openQuestion((Shell)container.getShell(), (String)Policy.bind("ConfigureTargetWizardConnection_Error_10"), (String)Policy.bind("ConfigureTargetWizard.errorOccurred", new Object[]{site.getURL().toExternalForm(), new Integer(code[0]), message[0]}));
    }

    protected AdaptableList getAvailableWizards() {
        AdaptableList result = new AdaptableList();
        IPluginRegistry registry = Platform.getPluginRegistry();
        IExtensionPoint point = registry.getExtensionPoint(this.pluginId, this.getExtensionPoint());
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    ConfigurationWizardElement wizard;
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(TAG_WIZARD) && (wizard = this.createWizardElement(element)) != null) {
                        result.add((IAdaptable)wizard);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    protected ConfigurationWizardElement createWizardElement(IConfigurationElement element) {
        String nameString = element.getAttribute(ATT_NAME);
        if (nameString == null) {
            return null;
        }
        ConfigurationWizardElement result = new ConfigurationWizardElement(nameString);
        if (this.initializeWizard(result, element)) {
            return result;
        }
        return null;
    }

    protected boolean initializeWizard(ConfigurationWizardElement element, IConfigurationElement config) {
        element.setID(config.getAttribute(ATT_ID));
        String description = "";
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            description = children[0].getValue();
        }
        element.setDescription(description);
        element.setConfigurationElement(config);
        String iconName = config.getAttribute(ATT_ICON);
        if (iconName != null) {
            IExtension extension = config.getDeclaringExtension();
            element.setImageDescriptor(TeamImages.getImageDescriptorFromExtension(extension, iconName));
        }
        if (element.getConfigurationElement() == null) {
            return false;
        }
        this.setForcePreviousAndNextButtons(true);
        return true;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.workbench = workbench;
        this.project = project;
    }
}

