/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.sync;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.sync.ChangedTeamContainer;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.MergeResource;
import org.eclipse.team.internal.ui.sync.TypedBufferedContent;

public class TeamFile
extends DiffElement
implements ICompareInput,
ITeamNode,
IAdaptable {
    private MergeResource mergeResource;
    private Shell shell;
    private ListenerList listeners;
    private TypedBufferedContent localByteContents;
    private TypedBufferedContent commonByteContents;
    private TypedBufferedContent remoteByteContents;
    boolean hasBeenSaved = false;
    private IProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    public TeamFile(IDiffContainer parent, MergeResource res, int changeType, Shell shell) {
        super(parent, changeType);
        Assert.isNotNull((Object)res);
        this.mergeResource = res;
        this.shell = shell;
        this.commonByteContents = new TypedBufferedContent(this, false){

            public InputStream createStream() throws CoreException {
                return TeamFile.this.mergeResource.getBaseRevision();
            }
        };
        this.remoteByteContents = new TypedBufferedContent(this, false){

            protected InputStream createStream() throws CoreException {
                return TeamFile.this.mergeResource.getLatestRevision();
            }
        };
        this.localByteContents = this.getResource().exists() ? this.getLocalTypedContent() : null;
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)l);
    }

    public void copy(boolean leftToRight) {
        if (leftToRight) {
            return;
        }
        this.getRight();
        ITypedElement left = this.getLeft();
        try {
            if (left == null) {
                this.saveChanges(new ByteArrayInputStream(new byte[0]));
                this.localByteContents = this.getLocalTypedContent();
            } else {
                this.saveChanges(null);
                this.localByteContents = null;
            }
        }
        catch (CoreException e) {
            TeamPlugin.log((IStatus)e.getStatus());
        }
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            TeamFile file = (TeamFile)other;
            return this.mergeResource.equals(file.mergeResource);
        }
        return super.equals(other);
    }

    public ITypedElement getAncestor() {
        if (this.mergeResource.hasBaseRevision()) {
            return this.commonByteContents;
        }
        return null;
    }

    public int getChangeDirection() {
        return this.getKind() & 0xC;
    }

    public int getChangeType() {
        return this.getKind() & 3;
    }

    public Image getImage() {
        return CompareUI.getImage((String)this.getType());
    }

    public ITypedElement getLeft() {
        return this.localByteContents;
    }

    public String getName() {
        if (this.hasBeenSaved) {
            return Policy.bind("TeamFile.modified", this.mergeResource.getName());
        }
        return this.mergeResource.getName();
    }

    public ITypedElement getRight() {
        if (this.mergeResource.hasLatestRevision()) {
            return this.remoteByteContents;
        }
        return null;
    }

    public String getType() {
        return this.mergeResource.getExtension();
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove((Object)listener);
        }
    }

    public int hashCode() {
        return this.mergeResource.hashCode();
    }

    public MergeResource getMergeResource() {
        return this.mergeResource;
    }

    public IResource getResource() {
        return this.mergeResource.getResource();
    }

    public String toString() {
        return "TeamFile(" + this.mergeResource.getName() + ")";
    }

    protected TypedBufferedContent getLocalTypedContent() {
        boolean outgoingDeletion = this.getChangeDirection() == 4 && this.getChangeType() == 2;
        final String name = this.getName();
        return new TypedBufferedContent(this, !outgoingDeletion){

            protected InputStream createStream() throws CoreException {
                return TeamFile.this.mergeResource.getLocalStream();
            }

            public void setContent(byte[] contents) {
                try {
                    if (contents == null) {
                        TeamFile.this.saveChanges(new ByteArrayInputStream(new byte[0]));
                    } else {
                        TeamFile.this.saveChanges(new ByteArrayInputStream(contents));
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)TeamUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Policy.bind("TeamFile.saveChanges", name), null, (IStatus)e.getStatus());
                }
                Display.getDefault().syncExec(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        3.access$0(this.this$1);
                    }
                });
            }

            public ITypedElement replace(ITypedElement child, ITypedElement other) {
                return null;
            }

            static /* synthetic */ void access$0(3 var0) {
                var0.fireContentChanged();
            }
        };
    }

    public void merged() {
        if (this.getChangeDirection() == 8) {
            switch (this.getChangeType()) {
                case 1: 
                case 3: {
                    this.setKind(7);
                    break;
                }
                case 2: {
                    this.setKind(15);
                }
            }
        } else {
            this.setKind(4 | this.getKind() & 3);
        }
        this.hasBeenSaved = false;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private void saveChanges(final InputStream is) throws CoreException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IFile file = (IFile)TeamFile.this.getResource();
                    if (is != null) {
                        if (!file.exists()) {
                            TeamFile.this.createParents(TeamFile.this.getParent(), TeamFile.this.getResource().getParent());
                            file.create(is, false, monitor);
                        } else {
                            file.setContents(is, false, true, monitor);
                        }
                    } else {
                        file.delete(false, true, monitor);
                        TeamFile.this.deleteParents(TeamFile.this.getParent(), TeamFile.this.getResource().getParent());
                    }
                    TeamFile.this.hasBeenSaved = true;
                    TeamFile.this.fireThreeWayInputChange();
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
    }

    private void createParents(IDiffContainer parentNode, IContainer parentFolder) throws CoreException {
        if (!parentFolder.exists() && parentFolder.getType() != 4) {
            this.createParents(parentNode.getParent(), parentFolder.getParent());
            ((IFolder)parentFolder).create(false, true, null);
            if (parentNode instanceof ChangedTeamContainer) {
                ((ChangedTeamContainer)parentNode).setKind(0);
            }
        }
    }

    private void deleteParents(IDiffContainer parentNode, IContainer parentFolder) throws CoreException {
        if (parentFolder.members().length == 0 && parentFolder.getType() != 4) {
            IContainer parent = parentFolder.getParent();
            parentFolder.delete(false, null);
            if (parentNode instanceof ChangedTeamContainer) {
                ((ChangedTeamContainer)parentNode).setKind(0);
            }
            this.deleteParents(parentNode.getParent(), parent);
        }
    }

    private void run(IRunnableWithProgress runnable) throws CoreException {
        try {
            if (this.monitor == null) {
                new ProgressMonitorDialog(this.shell).run(false, false, runnable);
            } else {
                runnable.run(this.monitor);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                throw (CoreException)e.getTargetException();
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.team.ui", 0, Policy.bind("simpleInternal"), e.getTargetException()));
        }
        catch (InterruptedException interruptedException) {}
    }

    private void fireThreeWayInputChange() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (TeamFile.this.listeners != null) {
                    Object[] listenerArray = TeamFile.this.listeners.getListeners();
                    int i = listenerArray.length;
                    while (--i >= 0) {
                        ((ICompareInputChangeListener)listenerArray[i]).compareInputChanged((ICompareInput)TeamFile.this);
                    }
                }
            }
        });
    }

    public boolean hasBeenSaved() {
        return this.hasBeenSaved;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.mergeResource.getResource();
        }
        return null;
    }
}

