/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.sync;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.sync.ITeamNode;

public class SyncSet {
    private HashSet set;

    public SyncSet(IStructuredSelection nodeSelection) {
        this.set = new HashSet(nodeSelection.size() + 1);
        this.collectNodes(nodeSelection);
    }

    private void collectNodes(IStructuredSelection selection) {
        Object[] nodes = selection.toArray();
        int i = 0;
        while (i < nodes.length) {
            this.recursivelyAdd((ITeamNode)nodes[i]);
            ++i;
        }
    }

    private void collectParentCreations(ITeamNode node) {
        IDiffContainer parent = node.getParent();
        if (parent != null && parent instanceof ITeamNode && parent.getKind() != 0) {
            this.set.add(parent);
            this.collectParentCreations((ITeamNode)parent);
        }
    }

    public ITeamNode[] getChangedNodes() {
        ArrayList<ITeamNode> nodeList = new ArrayList<ITeamNode>(this.set.size());
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            ITeamNode node = (ITeamNode)it.next();
            int dir = node.getChangeDirection();
            if (dir == 0) continue;
            nodeList.add(node);
        }
        ITeamNode[] nodes = new ITeamNode[nodeList.size()];
        nodeList.toArray(nodes);
        return nodes;
    }

    public IResource[] getResources() {
        ITeamNode[] changed = this.getChangedNodes();
        IResource[] resources = new IResource[changed.length];
        int i = 0;
        while (i < changed.length) {
            resources[i] = changed[i].getResource();
            ++i;
        }
        return resources;
    }

    public String getStatusLineMessage() {
        int incoming = 0;
        int outgoing = 0;
        int conflicts = 0;
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            ITeamNode next = (ITeamNode)it.next();
            switch (next.getChangeDirection()) {
                case 8: {
                    ++incoming;
                    break;
                }
                case 4: {
                    ++outgoing;
                    break;
                }
                case 12: {
                    ++conflicts;
                }
            }
        }
        StringBuffer result = new StringBuffer();
        if (conflicts == 0) {
            result.append(Policy.bind("SyncSet.noConflicts"));
        } else {
            result.append(Policy.bind("SyncSet.conflicts", new Object[]{Integer.toString(conflicts)}));
        }
        if (incoming == 0) {
            result.append(Policy.bind("SyncSet.noIncomings"));
        } else {
            result.append(Policy.bind("SyncSet.incomings", new Object[]{Integer.toString(incoming)}));
        }
        if (outgoing == 0) {
            result.append(Policy.bind("SyncSet.noOutgoings"));
        } else {
            result.append(Policy.bind("SyncSet.outgoings", new Object[]{Integer.toString(outgoing)}));
        }
        return result.toString();
    }

    public boolean hasConflicts() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            if (((ITeamNode)it.next()).getChangeDirection() != 12) continue;
            return true;
        }
        return false;
    }

    public boolean hasIncomingChanges() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            if (((ITeamNode)it.next()).getChangeDirection() != 8) continue;
            return true;
        }
        return false;
    }

    public boolean hasOutgoingChanges() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            if (((ITeamNode)it.next()).getChangeDirection() != 4) continue;
            return true;
        }
        return false;
    }

    public boolean hasAutoMergeableConflicts() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            ITeamNode node = (ITeamNode)it.next();
            if ((node.getKind() & 0x20) == 0) continue;
            return true;
        }
        return false;
    }

    private void recursivelyAdd(ITeamNode node) {
        if (this.set.add(node)) {
            if (node instanceof IDiffContainer) {
                IDiffElement[] children = ((IDiffContainer)node).getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof ITeamNode) {
                        this.recursivelyAdd((ITeamNode)children[i]);
                    }
                    ++i;
                }
            }
            this.collectParentCreations(node);
        }
    }

    public void removeConflictingNodes() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            ITeamNode node = (ITeamNode)it.next();
            if (node.getChangeDirection() != 12) continue;
            it.remove();
        }
    }

    public void removeOutgoingNodes() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            ITeamNode node = (ITeamNode)it.next();
            if (node.getChangeDirection() != 4) continue;
            it.remove();
        }
    }

    public void removeIncomingNodes() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            ITeamNode node = (ITeamNode)it.next();
            if (node.getChangeDirection() != 8) continue;
            it.remove();
        }
    }

    public void removeNonMergeableNodes() {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            ITeamNode node = (ITeamNode)it.next();
            if ((node.getKind() & 0x40) != 0) {
                it.remove();
                continue;
            }
            if (node.getChangeDirection() == 12) continue;
            it.remove();
        }
    }

    public void removeNonApplicableNodes(int direction) {
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            ITeamNode node = (ITeamNode)it.next();
            int nodeDirection = node.getKind() & 0xC;
            if (nodeDirection == 12 || nodeDirection == direction) continue;
            it.remove();
        }
    }

    public void remove(ITeamNode node) {
        this.set.remove(node);
    }

    protected HashSet getSyncSet() {
        return this.set;
    }
}

