/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.sync;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.ILocalSyncElement;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.sync.CatchupReleaseViewer;
import org.eclipse.team.internal.ui.sync.ChangedTeamContainer;
import org.eclipse.team.internal.ui.sync.ITeamNode;
import org.eclipse.team.internal.ui.sync.MergeResource;
import org.eclipse.team.internal.ui.sync.SyncSet;
import org.eclipse.team.internal.ui.sync.TeamFile;
import org.eclipse.team.internal.ui.sync.UnchangedTeamContainer;
import org.eclipse.ui.IViewSite;

public abstract class SyncCompareInput
extends CompareEditorInput {
    private IRemoteSyncElement[] trees;
    private CatchupReleaseViewer catchupReleaseViewer;
    private DiffNode diffRoot;
    private Shell shell;
    private IViewSite viewSite;
    private int granularity;
    private ICompareInputChangeListener listener = new ICompareInputChangeListener(){

        public void compareInputChanged(ICompareInput source) {
            SyncCompareInput.this.compareInputChanged(source);
        }
    };

    protected void compareInputChanged(ICompareInput source) {
        this.catchupReleaseViewer.update(source, new String[]{"team.ui.PropKind"});
        this.updateStatusLine();
    }

    public SyncCompareInput(int granularity) {
        super(new CompareConfiguration());
        this.privateSetSyncGranularity(granularity);
    }

    public SyncCompareInput() {
        this(1);
    }

    protected abstract IRemoteSyncElement[] createSyncElements(IProgressMonitor var1) throws TeamException;

    public Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.initialSelectionAndExpansionState();
        return result;
    }

    public abstract Viewer createDiffViewer(Composite var1);

    public DiffNode getDiffRoot() {
        return this.diffRoot;
    }

    private IDiffElement getFirstChange(IDiffElement root) {
        ITeamNode node;
        if (root instanceof ITeamNode && (node = (ITeamNode)root) instanceof TeamFile) {
            return node;
        }
        if (root instanceof IDiffContainer) {
            IDiffElement[] children = ((IDiffContainer)root).getChildren();
            IDiffElement result = null;
            int i = 0;
            while (i < children.length) {
                result = this.getFirstChange(children[i]);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    protected Shell getShell() {
        return this.shell;
    }

    public String getTitle() {
        return Policy.bind("SyncCompareInput.synchronize");
    }

    public CatchupReleaseViewer getViewer() {
        return this.catchupReleaseViewer;
    }

    public IViewSite getViewSite() {
        return this.viewSite;
    }

    boolean hasIncomingChanges() {
        if (this.diffRoot == null) {
            return false;
        }
        SyncSet set = new SyncSet((IStructuredSelection)new StructuredSelection((Object[])this.diffRoot.getChildren()));
        return set.hasIncomingChanges() || set.hasConflicts();
    }

    private void initialSelectionAndExpansionState() {
        IDiffElement next = this.getFirstChange((IDiffElement)this.diffRoot);
        if (next != null) {
            this.catchupReleaseViewer.setSelection((ISelection)new StructuredSelection((Object)next), true);
        } else {
            this.catchupReleaseViewer.collapseAll();
            this.catchupReleaseViewer.setSelection((ISelection)new StructuredSelection());
        }
    }

    public Object prepareInput(IProgressMonitor pm) throws InterruptedException, InvocationTargetException {
        if (pm.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            pm.beginTask(Policy.bind("SyncCompareInput.taskTitle"), 100);
            this.trees = this.createSyncElements(Policy.subMonitorFor(pm, 70));
            this.setMessage(null);
            if (this.trees.length == 0) {
                return null;
            }
            final TeamException[] exceptions = new TeamException[1];
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SyncCompareInput.this.diffRoot = new DiffNode(0);
                    try {
                        SyncCompareInput.this.doServerDelta(monitor);
                    }
                    catch (TeamException e) {
                        exceptions[0] = e;
                    }
                }
            };
            if (pm.isCanceled()) {
                throw new InterruptedException();
            }
            ResourcesPlugin.getWorkspace().run(runnable, Policy.subMonitorFor(pm, 30));
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
            if (pm.isCanceled()) {
                throw new InterruptedException();
            }
            if (!this.diffRoot.hasChildren()) {
                this.diffRoot = null;
            }
            this.updateStatusLine();
            return this.diffRoot;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (TeamException e) {
            throw new InvocationTargetException(e);
        }
    }

    void doServerDelta(IProgressMonitor pm) throws TeamException {
        pm.beginTask(null, this.trees.length * 1000);
        pm.setTaskName(Policy.bind("SyncCompareInput.taskTitle"));
        int i = 0;
        while (i < this.trees.length) {
            IRemoteSyncElement tree = this.trees[i];
            IProgressMonitor monitor = Policy.subMonitorFor(pm, 1000);
            monitor.beginTask(null, 1000);
            IDiffElement localRoot = this.collectResourceChanges(null, tree, monitor);
            monitor.done();
            this.makeParents(localRoot);
            ++i;
        }
    }

    protected IDiffElement collectResourceChanges(IDiffContainer parent, IRemoteSyncElement tree, IProgressMonitor pm) throws TeamException {
        int type = tree.getSyncKind(this.getSyncGranularity(), Policy.subMonitorFor(pm, 1));
        MergeResource mergeResource = new MergeResource(tree);
        if (tree.isContainer()) {
            ChangedTeamContainer element = new ChangedTeamContainer(parent, mergeResource, type);
            ILocalSyncElement[] children = tree.members(Policy.subMonitorFor(pm, 1));
            int i = 0;
            while (i < children.length) {
                this.collectResourceChanges((IDiffContainer)element, (IRemoteSyncElement)children[i], pm);
                ++i;
            }
            return element;
        }
        TeamFile file = new TeamFile(parent, mergeResource, type, this.shell);
        file.addCompareInputChangeListener(this.listener);
        return file;
    }

    public int getSyncGranularity() {
        return this.granularity;
    }

    public void setSyncGranularity(int granularity) {
        this.privateSetSyncGranularity(granularity);
        this.refresh();
    }

    private void privateSetSyncGranularity(int granularity) {
        this.granularity = granularity;
        if (granularity != 1) {
            this.granularity = this.isIgnoreWhitespace() ? 4 : 2;
        }
    }

    public void setIgnoreWhitespace(boolean ignore) {
        Boolean value = ignore ? Boolean.TRUE : Boolean.FALSE;
        this.getCompareConfiguration().setProperty("IGNORE_WHITESPACE", (Object)value);
        this.privateSetSyncGranularity(this.getSyncGranularity());
        if (this.granularity != 1) {
            this.refresh();
        }
    }

    public boolean isIgnoreWhitespace() {
        Object o = this.getCompareConfiguration().getProperty("IGNORE_WHITESPACE");
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return CompareUIPlugin.getDefault().getPreferenceStore().getBoolean("IGNORE_WHITESPACE");
    }

    private DiffContainer buildPath(DiffContainer root, IContainer resource) {
        Object c;
        DiffContainer parent = root;
        if (resource.getType() == 8) {
            return root;
        }
        if (resource.getType() != 4) {
            parent = this.buildPath(root, resource.getParent());
        }
        if ((c = (DiffContainer)parent.findChild(resource.getName())) == null) {
            c = new UnchangedTeamContainer((IDiffContainer)parent, (IResource)resource);
        }
        return c;
    }

    void makeParents(IDiffElement element) {
        IContainer parent = ((ITeamNode)element).getResource().getParent();
        DiffContainer container = this.buildPath((DiffContainer)this.diffRoot, parent);
        container.add(element);
    }

    public void refresh() {
        final Object[] input = new Object[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                input[0] = SyncCompareInput.this.prepareInput(monitor);
            }
        };
        try {
            this.run(op, Policy.bind("SyncCompareInput.refresh"));
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.catchupReleaseViewer.setInput(input[0]);
        if (input[0] == null) {
            MessageDialog.openInformation((Shell)this.shell, (String)Policy.bind("nothingToSynchronize"), (String)Policy.bind("SyncCompareInput.nothingText"));
        }
    }

    protected void run(IRunnableWithProgress op, String problemMessage) throws InterruptedException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        try {
            dialog.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            Object error = null;
            error = throwable instanceof TeamException ? ((TeamException)throwable).getStatus() : (throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.team.ui", 1, Policy.bind("simpleInternal"), throwable));
            ErrorDialog.openError((Shell)this.shell, (String)problemMessage, null, (IStatus)error);
            TeamUIPlugin.log(error);
            throw new InterruptedException();
        }
    }

    public void setViewSite(IViewSite viewSite) {
        this.viewSite = viewSite;
        this.shell = viewSite.getShell();
    }

    public void setViewer(CatchupReleaseViewer viewer) {
        this.catchupReleaseViewer = viewer;
    }

    public void updateStatusLine() {
        if (this.viewSite != null && !this.shell.isDisposed()) {
            Runnable update = new Runnable(){

                public void run() {
                    if (!SyncCompareInput.this.shell.isDisposed()) {
                        IStatusLineManager statusLine = SyncCompareInput.this.viewSite.getActionBars().getStatusLineManager();
                        if (SyncCompareInput.this.diffRoot == null) {
                            statusLine.setMessage(null);
                            statusLine.setErrorMessage(null);
                            return;
                        }
                        SyncSet set = SyncCompareInput.this.getSyncSet((IStructuredSelection)new StructuredSelection((Object[])SyncCompareInput.this.diffRoot.getChildren()));
                        if (set.hasConflicts()) {
                            statusLine.setMessage(null);
                            statusLine.setErrorMessage(set.getStatusLineMessage());
                        } else {
                            statusLine.setErrorMessage(null);
                            statusLine.setMessage(set.getStatusLineMessage());
                        }
                        SyncCompareInput.this.viewSite.getActionBars().updateActionBars();
                    }
                }
            };
            if (this.shell.getDisplay() != Display.getCurrent()) {
                this.shell.getDisplay().asyncExec(update);
            } else {
                update.run();
            }
        }
    }

    protected SyncSet getSyncSet(IStructuredSelection selection) {
        return new SyncSet(selection);
    }

    public boolean saveIfNecessary() {
        if (!this.isSaveNeeded()) {
            return true;
        }
        final boolean[] result = new boolean[1];
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    result[0] = MessageDialog.openQuestion((Shell)SyncCompareInput.this.getShell(), (String)Policy.bind("SyncView.saveTitle"), (String)Policy.bind("SyncView.saveMessage"));
                    if (result[0]) {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                5.access$0(this.this$1).saveChanges(monitor);
                            }
                        }, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    ErrorDialog.openError((Shell)SyncCompareInput.this.getShell(), (String)status.getMessage(), (String)Policy.bind("SyncView.errorSaving"), (IStatus)status);
                    result[0] = false;
                }
            }

            static /* synthetic */ SyncCompareInput access$0(5 var0) {
                return var0.SyncCompareInput.this;
            }
        });
        return result[0];
    }
}

