/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.sync;

import java.io.InputStream;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ui.Policy;

public class MergeResource {
    private IRemoteSyncElement syncTree;

    public MergeResource(IRemoteSyncElement syncTree) {
        this.syncTree = syncTree;
    }

    public InputStream getBaseRevision() throws CoreException {
        IRemoteResource remote = this.syncTree.getBase();
        if (remote != null && !remote.isContainer()) {
            try {
                return remote.getContents((IProgressMonitor)new NullProgressMonitor());
            }
            catch (TeamException teamException) {
                return null;
            }
        }
        return null;
    }

    public String getExtension() {
        if (this.syncTree.isContainer()) {
            return "FOLDER";
        }
        String name = this.getName();
        if (name != null) {
            int index = name.lastIndexOf(46);
            if (index == -1) {
                return "";
            }
            if (index == name.length() - 1) {
                return "";
            }
            return name.substring(index + 1);
        }
        return "FOLDER";
    }

    public InputStream getLatestRevision() throws CoreException {
        IRemoteResource remote = this.syncTree.getRemote();
        try {
            return remote.getContents((IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamException e) {
            throw new CoreException(e.getStatus());
        }
    }

    public InputStream getLocalStream() throws CoreException {
        IResource left = this.syncTree.getLocal();
        if (left == null) {
            return null;
        }
        if (left.exists() && left.getType() == 1) {
            return ((IFile)left).getContents(true);
        }
        return null;
    }

    public String getName() {
        return this.syncTree.getName();
    }

    public IResource getResource() {
        return this.syncTree.getLocal();
    }

    public IRemoteSyncElement getSyncElement() {
        return this.syncTree;
    }

    public boolean hasBaseRevision() {
        return this.syncTree.getBase() != null;
    }

    public boolean hasLatestRevision() {
        return this.syncTree.getRemote() != null;
    }

    public boolean isLeaf() {
        return !this.syncTree.isContainer();
    }

    public void setLabels(CompareConfiguration config) {
        String name = this.getName();
        config.setLeftLabel(Policy.bind("MergeResource.workspaceFile", name));
        IRemoteResource remote = this.syncTree.getRemote();
        if (remote != null) {
            config.setRightLabel(Policy.bind("MergeResource.repositoryFile", name));
        } else {
            config.setRightLabel(Policy.bind("MergeResource.noRepositoryFile"));
        }
        IRemoteResource base = this.syncTree.getBase();
        if (base != null) {
            config.setAncestorLabel(Policy.bind("MergeResource.commonFile", name));
        } else {
            config.setAncestorLabel(Policy.bind("MergeResource.noCommonFile"));
        }
    }
}

