/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.target.TargetManager;
import org.eclipse.team.internal.core.target.TargetProvider;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class TeamAction
extends ActionDelegate
implements IObjectActionDelegate {
    protected IStructuredSelection selection;
    protected Shell shell;
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;
    private IWorkbenchPart targetPart;
    static /* synthetic */ Class class$0;

    protected IProject[] getSelectedProjects() {
        ArrayList<Object> projects = null;
        if (!this.selection.isEmpty()) {
            projects = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof IProject) {
                    projects.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof IProject)) continue;
                projects.add(adapter);
            }
        }
        if (projects != null && !projects.isEmpty()) {
            IProject[] result = new IProject[projects.size()];
            projects.toArray(result);
            return result;
        }
        return new IProject[0];
    }

    protected IResource[] getSelectedResources() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof IResource) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof IResource)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            IResource[] result = new IResource[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new IResource[0];
    }

    protected Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        return TeamUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected final void run(final IRunnableWithProgress runnable, String problemMessage, int progressKind) {
        final Exception[] exceptions = new Exception[1];
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException interruptedException) {
                            exceptions[0] = null;
                        }
                    }
                });
                break;
            }
            default: {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
                    break;
                }
                catch (InvocationTargetException e) {
                    exceptions[0] = e;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    exceptions[0] = null;
                }
            }
        }
        if (exceptions[0] != null) {
            this.handle(exceptions[0], null, problemMessage);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            if (action != null) {
                this.setActionEnablement(action);
            }
        }
    }

    protected void setActionEnablement(IAction action) {
        try {
            action.setEnabled(this.isEnabled());
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() == 274) {
                action.setEnabled(true);
            }
            action.setEnabled(false);
            TeamPlugin.log((IStatus)e.getStatus());
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.targetPart = targetPart;
    }

    protected void handle(Exception exception, String title, String message) {
        IStatus status = null;
        boolean log = false;
        boolean dialog = false;
        if (exception instanceof TeamException) {
            status = ((TeamException)((Object)exception)).getStatus();
            log = false;
            dialog = true;
        } else if (exception instanceof InvocationTargetException) {
            Throwable t = ((InvocationTargetException)exception).getTargetException();
            if (t instanceof TeamException) {
                status = ((TeamException)t).getStatus();
                log = false;
                dialog = true;
            } else if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                log = true;
                dialog = true;
            } else {
                if (t instanceof InterruptedException) {
                    return;
                }
                status = new Status(4, "org.eclipse.team.ui", 1, Policy.bind("TeamAction.internal"), t);
                log = true;
                dialog = true;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.isOK()) {
            IStatus[] children;
            IStatus toShow = status;
            if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
                toShow = children[0];
            }
            if (title == null) {
                title = status.getMessage();
            }
            if (message == null) {
                message = status.getMessage();
            }
            if (dialog) {
                ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)toShow);
            }
            if (log) {
                TeamUIPlugin.log(toShow);
            }
        }
    }

    protected abstract boolean isEnabled() throws TeamException;

    protected Hashtable getProviderMapping() {
        return this.getProviderMapping(this.getSelectedResources());
    }

    protected Hashtable getProviderMapping(IResource[] resources) {
        Hashtable<RepositoryProvider, ArrayList<IResource>> result = new Hashtable<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    protected Hashtable getTargetProviderMapping() throws TeamException {
        return this.getTargetProviderMapping(this.getSelectedResources());
    }

    protected Hashtable getTargetProviderMapping(IResource[] resources) throws TeamException {
        Hashtable<TargetProvider, ArrayList<IResource>> result = new Hashtable<TargetProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            TargetProvider provider = TargetManager.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }

    protected IWorkbenchPage getTargetPage() {
        if (this.getTargetPart() == null) {
            return TeamUIPlugin.getActivePage();
        }
        return this.getTargetPart().getSite().getPage();
    }

    protected IViewPart showView(String viewId) {
        try {
            return this.getTargetPage().showView(viewId);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }
}

