/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.ConfigureProjectWizard;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.actions.TeamAction;

public class ConfigureProjectAction
extends TeamAction {
    public void run(IAction action) {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IProject project = ConfigureProjectAction.this.getSelectedProjects()[0];
                    ConfigureProjectWizard wizard = new ConfigureProjectWizard();
                    wizard.init(null, project);
                    WizardDialog dialog = new WizardDialog(ConfigureProjectAction.this.getShell(), (IWizard)wizard);
                    dialog.open();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, Policy.bind("ConfigureProjectAction.configureProject"), 2);
    }

    protected boolean isEnabled() {
        IProject[] selectedProjects = this.getSelectedProjects();
        if (selectedProjects.length != 1) {
            return false;
        }
        if (!selectedProjects[0].isAccessible()) {
            return false;
        }
        return RepositoryProvider.getProvider((IProject)selectedProjects[0]) == null;
    }
}

