/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TeamUIPlugin
extends AbstractUIPlugin {
    private static TeamUIPlugin instance;
    public static final String ID = "org.eclipse.team.ui";
    private static List propertyChangeListeners;

    static {
        propertyChangeListeners = new ArrayList(5);
    }

    public TeamUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        instance = this;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        IPluginDescriptor plugin = element.getDeclaringExtension().getDeclaringPluginDescriptor();
        if (plugin.isPluginActivated()) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = TeamUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static TeamUIPlugin getPlugin() {
        return instance;
    }

    protected void initializePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("pref_always_in_incoming_outgoing", false);
    }

    public static void log(IStatus status) {
        TeamUIPlugin.getPlugin().getLog().log(status);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runWithProgress(Shell parent, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean createdShell;
        block7: {
            block6: {
                createdShell = false;
                try {
                    if (parent == null || parent.isDisposed()) {
                        Display display = Display.getCurrent();
                        if (display == null) {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                            Object var5_5 = null;
                            if (!createdShell) return;
                            break block6;
                        }
                        parent = display.getActiveShell();
                        if (parent == null) {
                            parent = new Shell(display);
                            createdShell = true;
                        }
                    }
                    final Exception[] holder = new Exception[1];
                    BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            try {
                                runnable.run((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (InvocationTargetException e) {
                                holder[0] = e;
                            }
                            catch (InterruptedException e) {
                                holder[0] = e;
                            }
                        }
                    });
                    if (holder[0] != null) {
                        if (!(holder[0] instanceof InvocationTargetException)) throw (InterruptedException)holder[0];
                        throw (InvocationTargetException)holder[0];
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (!createdShell) throw throwable;
                    parent.dispose();
                    throw throwable;
                }
            }
            parent.dispose();
            return;
        }
        Object var5_7 = null;
        if (!createdShell) return;
        parent.dispose();
    }

    public static void runWithProgressDialog(Shell parent, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(parent).run(cancelable, cancelable, runnable);
    }

    public void startup() throws CoreException {
        Policy.localize("org.eclipse.team.internal.ui.messages");
        this.initializePreferences();
    }

    public static void handle(Throwable t) {
        Object error = null;
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        error = t instanceof CoreException ? ((CoreException)t).getStatus() : (t instanceof TeamException ? ((TeamException)t).getStatus() : new Status(4, ID, 1, Policy.bind("simpleInternal"), t));
        Shell shell = new Shell(Display.getDefault());
        if (error.getSeverity() == 1) {
            MessageDialog.openInformation((Shell)shell, (String)Policy.bind("information"), (String)error.getMessage());
        } else {
            ErrorDialog.openError((Shell)shell, (String)Policy.bind("exception"), null, (IStatus)error);
        }
        shell.dispose();
        if (!(t instanceof TeamException)) {
            TeamUIPlugin.log(error);
        }
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static void broadcastPropertyChange(PropertyChangeEvent event) {
        Iterator it = propertyChangeListeners.iterator();
        while (it.hasNext()) {
            IPropertyChangeListener listener = (IPropertyChangeListener)it.next();
            listener.propertyChange(event);
        }
    }
}

