/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TeamPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button syncModeButton;

    public TeamPreferencePage() {
        this.setDescription(Policy.bind("TeamPreferencePage.General_settings_for_Team_support_1"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.ui.team_preference_page_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.syncModeButton = this.createCheckBox(composite, Policy.bind("TeamPreferencePage.&Use_Incoming/Outgoing_mode_when_synchronizing_2"));
        this.initializeValues();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        button.setLayoutData((Object)data);
        return button;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return TeamUIPlugin.getPlugin().getPreferenceStore();
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        this.syncModeButton.setSelection(store.getDefaultBoolean("pref_always_in_incoming_outgoing"));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("pref_always_in_incoming_outgoing", this.syncModeButton.getSelection());
        TeamUIPlugin.getPlugin().savePluginPreferences();
        return true;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.syncModeButton.setSelection(store.getBoolean("pref_always_in_incoming_outgoing"));
    }

    public void init(IWorkbench workbench) {
    }
}

