/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.ImportProjectSetMainPage;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.ProjectSetContentHandler;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProjectSetImportWizard
extends Wizard
implements IImportWizard {
    ImportProjectSetMainPage mainPage;
    public static String lastFile;

    public ProjectSetImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Policy.bind("ProjectSetImportWizard.Project_Set_1"));
    }

    public void addPages() {
        this.mainPage = new ImportProjectSetMainPage("projectSetMainPage", Policy.bind("ProjectSetImportWizard.Import_a_Project_Set_3"), TeamImages.getImageDescriptor("wizban/import_projectset_wizban.gif"));
        this.mainPage.setFileName(lastFile);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        boolean[] result;
        block6: {
            IWorkingSet existingSet;
            final String workingSetName = this.mainPage.getWorkingSetName();
            if (workingSetName != null && (existingSet = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName)) != null && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Policy.bind("ProjectSetImportWizard.workingSetExistsTitle"), (String)Policy.bind("ProjectSetImportWizard.workingSetExistsMessage", workingSetName))) {
                return false;
            }
            result = new boolean[1];
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                        InputStreamReader reader = null;
                        try {
                            try {
                                String filename;
                                lastFile = filename = ProjectSetImportWizard.this.mainPage.getFileName();
                                reader = new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8");
                                SAXParser parser = new SAXParser();
                                ProjectSetContentHandler handler = new ProjectSetContentHandler();
                                parser.setContentHandler((ContentHandler)handler);
                                InputSource source = new InputSource(reader);
                                parser.parse(source);
                                Map map = handler.getReferences();
                                ArrayList<IProject> newProjects = new ArrayList<IProject>();
                                if (map.size() == 0 && handler.isVersionOne) {
                                    IProject[] projects;
                                    IProjectSetSerializer serializer = Team.getProjectSetSerializer((String)"versionOneSerializer");
                                    if (serializer != null && (projects = serializer.addToWorkspace(new String[0], filename, (Object)ProjectSetImportWizard.this.getShell(), monitor)) != null) {
                                        newProjects.addAll(Arrays.asList(projects));
                                    }
                                } else {
                                    Iterator it = map.keySet().iterator();
                                    while (it.hasNext()) {
                                        IProject[] projects;
                                        String id = (String)it.next();
                                        List references = (List)map.get(id);
                                        IProjectSetSerializer serializer = Team.getProjectSetSerializer((String)id);
                                        if (serializer == null || (projects = serializer.addToWorkspace(references.toArray(new String[references.size()]), filename, (Object)ProjectSetImportWizard.this.getShell(), monitor)) == null) continue;
                                        newProjects.addAll(Arrays.asList(projects));
                                    }
                                }
                                if (workingSetName != null) {
                                    ProjectSetImportWizard.this.createWorkingSet(workingSetName, newProjects.toArray(new IProject[newProjects.size()]));
                                }
                                result[0] = true;
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (SAXException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_20 = null;
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            throw throwable;
                        }
                        Object var14_21 = null;
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof TeamException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                    return false;
                }
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (!(target instanceof Error)) break block6;
                throw (Error)target;
            }
        }
        return result[0];
    }

    private void createWorkingSet(String workingSetName, IProject[] projects) {
        IWorkingSetManager manager = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
        IWorkingSet oldSet = manager.getWorkingSet(workingSetName);
        if (oldSet == null) {
            IWorkingSet newSet = manager.createWorkingSet(workingSetName, (IAdaptable[])projects);
            manager.addWorkingSet(newSet);
        } else {
            oldSet.setElements((IAdaptable[])projects);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

