/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.ExportProjectSetMainPage;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.ProjectSetImportWizard;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ProjectSetExportWizard
extends Wizard
implements IExportWizard {
    ExportProjectSetMainPage mainPage;
    IStructuredSelection selection;

    public ProjectSetExportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Policy.bind("ProjectSetExportWizard.Project_Set_1"));
    }

    public void addPages() {
        this.mainPage = new ExportProjectSetMainPage("projectSetMainPage", Policy.bind("ProjectSetExportWizard.Export_a_Project_Set_3"), TeamImages.getImageDescriptor("wizban/export_projectset_wizban.gif"));
        IProject[] projects = this.selection.toList().toArray(new IProject[0]);
        this.mainPage.setSelectedProjects(projects);
        this.mainPage.setFileName(ProjectSetImportWizard.lastFile);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        boolean[] result;
        block5: {
            result = new boolean[1];
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        List list;
                        String id;
                        boolean r;
                        String filename = ProjectSetExportWizard.this.mainPage.getFileName();
                        Path path = new Path(filename);
                        if (path.getFileExtension() == null) {
                            filename = String.valueOf(filename) + ".psf";
                        }
                        ProjectSetImportWizard.lastFile = filename;
                        File file = new File(filename);
                        File parentFile = file.getParentFile();
                        if (parentFile != null && !parentFile.exists()) {
                            r = MessageDialog.openQuestion((Shell)ProjectSetExportWizard.this.getShell(), (String)Policy.bind("ProjectSetExportWizard.Question_4"), (String)Policy.bind("ProjectSetExportWizard.Target_directory_does_not_exist._Would_you_like_to_create_it__5"));
                            if (!r) {
                                result[0] = false;
                                return;
                            }
                            r = parentFile.mkdirs();
                            if (!r) {
                                MessageDialog.openError((Shell)ProjectSetExportWizard.this.getShell(), (String)Policy.bind("ProjectSetExportWizard.Export_Problems_6"), (String)Policy.bind("ProjectSetExportWizard.An_error_occurred_creating_the_target_directory_7"));
                                result[0] = false;
                                return;
                            }
                        }
                        if (file.exists() && file.isFile() && !(r = MessageDialog.openQuestion((Shell)ProjectSetExportWizard.this.getShell(), (String)Policy.bind("ProjectSetExportWizard.Question_8"), (String)Policy.bind("ProjectSetExportWizard.Target_already_exists._Would_you_like_to_overwrite_it__9")))) {
                            result[0] = false;
                            return;
                        }
                        IProject[] projects = ProjectSetExportWizard.this.mainPage.getSelectedProjects();
                        HashMap<String, ArrayList<IProject>> map = new HashMap<String, ArrayList<IProject>>();
                        int i = 0;
                        while (i < projects.length) {
                            IProject project = projects[i];
                            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                            if (provider != null) {
                                id = provider.getID();
                                list = (ArrayList<IProject>)map.get(id);
                                if (list == null) {
                                    list = new ArrayList<IProject>();
                                    map.put(id, (ArrayList<IProject>)list);
                                }
                                list.add(project);
                            }
                            ++i;
                        }
                        Shell shell = ProjectSetExportWizard.this.getShell();
                        BufferedWriter writer = null;
                        try {
                            try {
                                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                                writer.newLine();
                                writer.write("<psf version=\"2.0\">");
                                writer.newLine();
                                Iterator it = map.keySet().iterator();
                                monitor.beginTask(null, 1000 * map.keySet().size());
                                while (it.hasNext()) {
                                    id = (String)it.next();
                                    writer.write("\t<provider id=\"");
                                    writer.write(id);
                                    writer.write("\">");
                                    writer.newLine();
                                    list = (List)map.get(id);
                                    IProject[] projectArray = list.toArray(new IProject[list.size()]);
                                    IProjectSetSerializer serializer = Team.getProjectSetSerializer((String)id);
                                    if (serializer != null) {
                                        String[] references = serializer.asReference(projectArray, (Object)shell, (IProgressMonitor)new SubProgressMonitor(monitor, 990));
                                        int i2 = 0;
                                        while (i2 < references.length) {
                                            writer.write("\t\t<project reference=\"");
                                            writer.write(references[i2]);
                                            writer.write("\"/>");
                                            writer.newLine();
                                            ++i2;
                                        }
                                    }
                                    writer.write("\t</provider>");
                                    writer.newLine();
                                }
                                writer.write("</psf>");
                                writer.newLine();
                                result[0] = true;
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_22 = null;
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            throw throwable;
                        }
                        Object var17_23 = null;
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        Iterator iter = map.keySet().iterator();
                        while (iter.hasNext()) {
                            ProjectSetCapability capability;
                            id = (String)iter.next();
                            RepositoryProviderType type = RepositoryProviderType.getProviderType((String)id);
                            if (type == null || (capability = type.getProjectSetCapability()) == null) continue;
                            capability.projectSetCreated(file, (Object)shell, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof TeamException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                    return false;
                }
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (!(target instanceof Error)) break block5;
                throw (Error)target;
            }
        }
        return result[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

