/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ExportProjectSetMainPage
extends TeamWizardPage {
    Text fileText;
    String file = "";
    Button browseButton;
    List selectedProjects = new ArrayList();
    CheckboxTableViewer tableViewer;
    Table table;

    public ExportProjectSetMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.ui.export_project_set_page_context");
        this.createLabel(composite, Policy.bind("ExportProjectSetMainPage.Select_the_projects_to_include_in_the_project_set__2"));
        this.table = new Table(composite, 2848);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.table.setLayout((Layout)new TableLayout());
        GridData data = new GridData(1808);
        data.heightHint = 300;
        this.table.setLayoutData((Object)data);
        this.tableViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IProject project = (IProject)event.getElement();
                if (event.getChecked()) {
                    ExportProjectSetMainPage.this.selectedProjects.add(project);
                } else {
                    ExportProjectSetMainPage.this.selectedProjects.remove(project);
                }
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        this.createLabel(composite, Policy.bind("ExportProjectSetMainPage.Project_Set_File_Name__3"));
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createLabel(inner, Policy.bind("ExportProjectSetMainPage.&File_name__1"));
        this.fileText = this.createTextField(inner);
        if (this.file != null) {
            this.fileText.setText(this.file);
        }
        this.fileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ExportProjectSetMainPage.this.file = ExportProjectSetMainPage.this.fileText.getText();
                ExportProjectSetMainPage.this.updateEnablement();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(Policy.bind("ExportProjectSetMainPage.Browse_4"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(ExportProjectSetMainPage.this.getShell(), 8192);
                d.setFilterExtensions(new String[]{"*.psf"});
                d.setFilterNames(new String[]{Policy.bind("ExportProjectSetMainPage.Project_Set_Files_3")});
                d.setFileName(Policy.bind("ExportProjectSetMainPage.default"));
                d.setFilterPath(new File(".").getAbsolutePath());
                String f = d.open();
                if (f != null) {
                    ExportProjectSetMainPage.this.fileText.setText(f);
                    ExportProjectSetMainPage.this.file = f;
                }
            }
        });
        this.initializeProjects();
        this.setControl((Control)composite);
        this.updateEnablement();
    }

    private void initializeProjects() {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (RepositoryProvider.getProvider((IProject)workspaceProjects[i]) != null) {
                projectList.add(workspaceProjects[i]);
            }
            ++i;
        }
        this.tableViewer.setInput((Object)projectList.toArray(new IProject[projectList.size()]));
        if (this.selectedProjects != null) {
            this.tableViewer.setCheckedElements((Object[])this.selectedProjects.toArray(new IProject[this.selectedProjects.size()]));
        }
    }

    private void updateEnablement() {
        boolean complete;
        if (this.selectedProjects.size() == 0) {
            this.setMessage(null);
            complete = false;
        } else if (this.file.length() == 0) {
            this.setMessage(null);
            complete = false;
        } else {
            File f = new File(this.file);
            if (f.isDirectory()) {
                this.setMessage(Policy.bind("ExportProjectSetMainPage.You_have_specified_a_folder_5"), 3);
                complete = false;
            } else {
                complete = true;
            }
        }
        if (complete) {
            this.setMessage(null);
        }
        this.setPageComplete(complete);
    }

    public String getFileName() {
        return this.file;
    }

    public void setFileName(String file) {
        if (file != null) {
            this.file = file;
        }
    }

    public IProject[] getSelectedProjects() {
        return this.selectedProjects.toArray(new IProject[this.selectedProjects.size()]);
    }

    public void setSelectedProjects(IProject[] selectedProjects) {
        this.selectedProjects.addAll(Arrays.asList(selectedProjects));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileText.setFocus();
        }
    }

    class ProjectContentProvider
    extends WorkbenchContentProvider {
        ProjectContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof IProject[]) {
                return (IProject[])element;
            }
            return null;
        }
    }
}

