/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.internal.ui.ConfigurationWizardElement;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConfigureProjectWizardMainPage
extends WizardPage {
    private Table table;
    private TableViewer viewer;
    private AdaptableList wizards;
    private IWorkbench workbench;
    private IProject project;
    private String description;
    private IConfigurationWizard selectedWizard;

    public ConfigureProjectWizardMainPage(String pageName, String title, ImageDescriptor titleImage, AdaptableList wizards) {
        this(pageName, title, titleImage, wizards, Policy.bind("ConfigureProjectWizardMainPage.selectRepository"));
    }

    public ConfigureProjectWizardMainPage(String pageName, String title, ImageDescriptor titleImage, AdaptableList wizards, String description) {
        super(pageName, title, titleImage);
        this.wizards = wizards;
        this.description = description;
    }

    public IConfigurationWizard getSelectedWizard() {
        return this.selectedWizard;
    }

    public boolean canFlipToNextPage() {
        return this.selectedWizard != null && this.selectedWizard.getPageCount() > 0;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.ui.share_project_page_context");
        Label label = new Label(composite, 16384);
        label.setText(this.description);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.table = new Table(composite, 2052);
        data = new GridData(1808);
        data.heightHint = this.table.getItemHeight() * 7;
        this.table.setLayoutData((Object)data);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    ConfigureProjectWizardMainPage.this.selectedWizard = null;
                    ConfigureProjectWizardMainPage.this.setPageComplete(false);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    ConfigureProjectWizardMainPage.this.selectedWizard = null;
                    ConfigureProjectWizardMainPage.this.setPageComplete(false);
                    return;
                }
                ConfigurationWizardElement selectedElement = (ConfigurationWizardElement)((Object)ss.getFirstElement());
                try {
                    ConfigureProjectWizardMainPage.this.selectedWizard = (IConfigurationWizard)selectedElement.createExecutableExtension();
                    ConfigureProjectWizardMainPage.this.selectedWizard.init(ConfigureProjectWizardMainPage.this.workbench, ConfigureProjectWizardMainPage.this.project);
                }
                catch (CoreException coreException) {
                    return;
                }
                ConfigureProjectWizardMainPage.this.selectedWizard.addPages();
                ConfigureProjectWizardMainPage.this.setPageComplete(true);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConfigureProjectWizardMainPage.this.getWizard().getContainer().showPage(ConfigureProjectWizardMainPage.this.getNextPage());
            }
        });
        this.viewer.setInput((Object)this.wizards);
    }

    public IWizardPage getNextPage() {
        if (this.selectedWizard == null) {
            return null;
        }
        return this.selectedWizard.getStartingPage();
    }

    public void setWorkbench(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.table.setFocus();
        }
    }
}

