/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.config.ui.preferences;

import com.tssap.config.ConfigPlugin;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkspacePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String userName;
    private String userDefaultWorkspace;
    private Properties userDirProps = new Properties();
    private File propertyFile;
    private Text currentWorkspaceText;
    private Text defaultWorkspaceText;
    private Button browseBtn;

    public void init(IWorkbench workbench) {
        String allUserDir;
        this.userName = System.getProperty("user.name");
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            this.userName = this.userName.toLowerCase();
        }
        if ((allUserDir = System.getProperty("allUserDir")) != null && !allUserDir.equals("")) {
            this.propertyFile = new File(allUserDir, "SAP/workspace.properties");
            try {
                FileInputStream stream = new FileInputStream(this.propertyFile);
                this.userDirProps.load(stream);
                stream.close();
                this.userDefaultWorkspace = this.userDirProps.getProperty(this.userName);
            }
            catch (IOException e) {
                ILog log = ConfigPlugin.getInstance().getLog();
                log.log((IStatus)new Status(4, ConfigPlugin.pluginId, 0, "Couldn't read default workspace location", (Throwable)e));
            }
        }
    }

    protected Control createContents(Composite parent) {
        IGridLayoutPane pane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        pane.setLayoutData((Object)pane.createGridLayoutData(4, 4, true, true).getGridData());
        if (this.propertyFile == null) {
            IGridLayoutPane disablePane = pane.addGridLayoutPane(2, pane.createGridLayoutData(4, 4, true, true));
            Image image = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_ERROR_TSK");
            disablePane.addImage(image, false);
            IGridLayoutData descriptionTextGridLayout = disablePane.createGridLayoutData(4, 1, true, true);
            descriptionTextGridLayout.getGridData().horizontalIndent = 0;
            GridData data = descriptionTextGridLayout.getGridData();
            data.widthHint = this.convertWidthInCharsToPixels(25);
            Label descriptionLabel = new Label(disablePane.getComposite(), 64);
            descriptionLabel.setLayoutData((Object)data);
            descriptionLabel.setFont(disablePane.getComposite().getFont());
            descriptionLabel.setText("This preference page is currently deactivated.\nThe workspace information is not available. You may have executed \"eclipse.exe\" instead of \"SapIDE.exe\".");
            return pane.getComposite();
        }
        IGridLayoutData currentWorkspaceLabelGridLayout = pane.createGridLayoutData(4, 2, true, false);
        currentWorkspaceLabelGridLayout.getGridData().horizontalIndent = 0;
        Label currentWorkspaceLabel = pane.addTextLabel("Current workspace:", currentWorkspaceLabelGridLayout);
        IGridLayoutData currentWorkspaceTextGridLayout = pane.createGridLayoutData(4, 2, true, false);
        currentWorkspaceTextGridLayout.getGridData().horizontalIndent = 0;
        this.currentWorkspaceText = pane.addTextField("", true, currentWorkspaceTextGridLayout);
        IGridLayoutPane defaultPane = PaneFactory.createGridLayoutPaneWithTitle((Composite)pane.getComposite(), (String)("Default workspace of user " + this.userName), (int)2);
        defaultPane.setLayoutData((Object)defaultPane.createGridLayoutData(4, 2, true, false).getGridData());
        IGridLayoutData defaultWorkspaceTextGridLayout = defaultPane.createGridLayoutData(4, 2, true, false);
        defaultWorkspaceTextGridLayout.getGridData().horizontalIndent = 0;
        this.defaultWorkspaceText = defaultPane.addTextField("", defaultWorkspaceTextGridLayout);
        this.defaultWorkspaceText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                WorkspacePreferencePage.this.validatePage();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        IGridLayoutData browseBtnGridLayout = defaultPane.createGridLayoutData(3, 2);
        browseBtnGridLayout.getGridData().horizontalIndent = 0;
        this.browseBtn = defaultPane.addPushButton("Browse....", browseBtnGridLayout);
        this.browseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String dir = WorkspacePreferencePage.this.defaultWorkspaceText.getText();
                Shell shell = new Shell();
                DirectoryDialog dialog = new DirectoryDialog(shell);
                dialog.setMessage("Message");
                dialog.setText("Text");
                if (dir != null && !dir.equals("")) {
                    dialog.setFilterPath(dir);
                } else if (WorkspacePreferencePage.this.userDefaultWorkspace != null && !WorkspacePreferencePage.this.userDefaultWorkspace.equals("")) {
                    dialog.setFilterPath(WorkspacePreferencePage.this.userDefaultWorkspace);
                }
                String selectedDir = dialog.open();
                if (selectedDir != null && !selectedDir.equals("")) {
                    WorkspacePreferencePage.this.defaultWorkspaceText.setText(selectedDir);
                }
                WorkspacePreferencePage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        IGridLayoutData descriptionTextGridLayout = defaultPane.createGridLayoutData(4, 4, 2, 1);
        descriptionTextGridLayout.getGridData().horizontalIndent = 0;
        GridData data = descriptionTextGridLayout.getGridData();
        data.heightHint = this.convertHeightInCharsToPixels(17);
        data.widthHint = this.convertWidthInCharsToPixels(72);
        Label descriptionLabel = new Label(defaultPane.getComposite(), 64);
        descriptionLabel.setFont(pane.getComposite().getFont());
        descriptionLabel.setLayoutData((Object)data);
        descriptionLabel.setText("You specify your personal default workspace when you start SAP NetWeaver Developer Studio for the first time. It will normally be used whenever you start SAP NetWeaver Developer Studio. If you change your default workspace, the new location will be active after you restart SAP NetWeaver Developer Studio.\n\nYou can use another workspace without changing your default workspace:\n1. Copy the SAP NetWeaver Developer Studio desktop shortcut.\n2. From the context menu of the new shortcut icon, select \"Properties\".\n3. In the \"Target\" field, add \" -data <workspace location>\".\n\nExample:\nC:\\Program Files\\SAP\\JDT\\eclipse\\SapIde.exe  -vm \"C:\\j2sdk1.4.2\\jre\\bin\\javaw.exe\" -data \"C:\\java\\all workspaces\\myWorkspace\"");
        String currentWorkspace = System.getProperty("user.workspace");
        if (currentWorkspace != null && !currentWorkspace.equals("")) {
            this.currentWorkspaceText.setText(currentWorkspace);
        }
        if (this.userDefaultWorkspace != null && !this.userDefaultWorkspace.equals("")) {
            this.defaultWorkspaceText.setText(this.userDefaultWorkspace);
        }
        this.validatePage();
        return pane.getComposite();
    }

    public boolean performOk() {
        if (this.defaultWorkspaceText == null) {
            return true;
        }
        String dir = this.defaultWorkspaceText.getText();
        if (dir != null && !dir.equals("")) {
            this.userDefaultWorkspace = dir;
            this.userDirProps.setProperty(this.userName, dir);
        }
        try {
            FileOutputStream stream = new FileOutputStream(this.propertyFile);
            this.userDirProps.store(stream, "User Workspace definition");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void validatePage() {
        String dir = this.defaultWorkspaceText.getText();
        this.setErrorMessage(null);
        this.setValid(true);
    }

    protected void performDefaults() {
        if (this.defaultWorkspaceText != null) {
            String userHomeDir = System.getProperty("user.home");
            File defaultPath = new File(userHomeDir, "Documents/SAP/workspace");
            this.defaultWorkspaceText.setText(defaultPath.getAbsolutePath());
        }
    }
}

