/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.config.ui.preferences;

import com.tssap.config.ConfigConstants;
import com.tssap.config.ConfigPlugin;
import com.tssap.config.ProxySettings;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ProxyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ConfigConstants {
    private Preferences preferences = ConfigPlugin.getInstance().getPluginPreferences();
    Text proxyHostField;
    Text proxyPortField;
    Button useProxyButton;
    Button useNoProxyButton;
    Text noProxyField;

    public ProxyPreferencePage() {
        this.setDescription("Make your Proxy Settings");
    }

    protected Control createContents(Composite parent) {
        ProxySettings proxy = ProxySettings.loadFromPreferences(this.preferences);
        IGridLayoutPane preferencePane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
        preferencePane.setLayoutData((Object)new GridData(1808));
        IGridLayoutPane proxyPane = PaneFactory.createGridLayoutPaneWithTitle((Composite)preferencePane.getComposite(), (String)"Proxy server", (int)1);
        proxyPane.setLayoutData((Object)new GridData(768));
        IGridLayoutPane useProxyPane = proxyPane.addGridLayoutPane(1);
        this.useProxyButton = useProxyPane.addCheckBox("Use a proxy server");
        this.useProxyButton.setSelection(proxy.isProxySet());
        IGridLayoutPane innerProxyPane = proxyPane.addGridLayoutPane(1);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 10;
        gl.verticalSpacing = 10;
        innerProxyPane.getComposite().setLayout((Layout)gl);
        Composite proxyHostPortPane = new Composite(innerProxyPane.getComposite(), 0);
        RowLayout phpprl = new RowLayout(256);
        phpprl.spacing = 10;
        proxyHostPortPane.setLayout((Layout)phpprl);
        Label l1 = new Label(proxyHostPortPane, 0);
        l1.setText("Address :");
        this.proxyHostField = new Text(proxyHostPortPane, 2048);
        this.proxyHostField.setText(proxy.getHost());
        Label l2 = new Label(proxyHostPortPane, 0);
        l2.setText("Port :");
        this.proxyPortField = new Text(proxyHostPortPane, 2048);
        this.proxyPortField.setText(Integer.toString(proxy.getPort()));
        RowData hostFieldRowData = new RowData();
        hostFieldRowData.width = 150;
        this.proxyHostField.setLayoutData((Object)hostFieldRowData);
        RowData portFieldRowData = new RowData();
        portFieldRowData.width = 28;
        this.proxyPortField.setLayoutData((Object)portFieldRowData);
        this.useNoProxyButton = innerProxyPane.addCheckBox("Exclude the following adresses:");
        this.useNoProxyButton.setSelection(proxy.isApplyNoProxy());
        IGridLayoutPane innerNoProxyPane = PaneFactory.createGridLayoutPaneWithTitle((Composite)innerProxyPane.getComposite(), (String)"Exceptions", (int)1);
        GridLayout glp = new GridLayout();
        glp.marginWidth = 10;
        glp.marginHeight = 10;
        innerNoProxyPane.getComposite().setLayout((Layout)glp);
        innerNoProxyPane.addTextLabel("Do not use proxy server for adresses beginning with:");
        Composite noProxyFieldPane = new Composite(innerNoProxyPane.getComposite(), 0);
        RowLayout npfprl = new RowLayout(512);
        npfprl.marginLeft = 0;
        noProxyFieldPane.setLayout((Layout)npfprl);
        this.noProxyField = new Text(noProxyFieldPane, 2560);
        this.noProxyField.setText(proxy.getNoProxy());
        RowData noProxyFieldData = new RowData();
        noProxyFieldData.width = 280;
        noProxyFieldData.height = 29;
        this.noProxyField.setLayoutData((Object)noProxyFieldData);
        IGridLayoutPane labelPane = innerNoProxyPane.addGridLayoutPane(1);
        labelPane.addTextLabel("Use semicolons (;) to separate entries. A wildcard character (*) can be used for matching.");
        labelPane.addTextLabel("E.g.: \"*.foo.com;localhost\"");
        this.validatePage();
        this.useProxyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ProxyPreferencePage.this.validatePage();
            }
        });
        this.proxyPortField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                ProxyPreferencePage.this.validatePage();
            }
        });
        this.useNoProxyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ProxyPreferencePage.this.validatePage();
            }
        });
        return preferencePane.getComposite();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        boolean _useProxy = this.useProxyButton.getSelection();
        String proxyHost = this.proxyHostField.getText();
        String proxyPort = this.proxyPortField.getText();
        boolean _useNoProxy = this.useNoProxyButton.getSelection();
        String _noProxy = this.noProxyField.getText();
        int iPort = 0;
        try {
            iPort = Integer.parseInt(proxyPort);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        ProxySettings proxy = new ProxySettings(_useProxy, proxyHost, iPort, _noProxy, _useNoProxy);
        this.noProxyField.setText(proxy.getNoProxy());
        proxy.saveToPreferences(this.preferences);
        ConfigPlugin.getInstance().writeSystemProperties(proxy);
        return super.performOk();
    }

    private boolean validatePage() {
        if (this.useProxyButton.getSelection()) {
            this.proxyHostField.setEnabled(true);
            this.proxyPortField.setEnabled(true);
            this.useNoProxyButton.setEnabled(true);
            if (this.useNoProxyButton.getSelection()) {
                this.noProxyField.setEnabled(true);
            } else {
                this.noProxyField.setEnabled(false);
            }
        } else {
            this.proxyHostField.setEnabled(false);
            this.proxyPortField.setEnabled(false);
            this.useNoProxyButton.setEnabled(false);
            this.noProxyField.setEnabled(false);
        }
        this.setErrorMessage(null);
        boolean valid = true;
        if (this.useProxyButton.getSelection()) {
            try {
                int port = Integer.parseInt(this.proxyPortField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                valid = false;
                this.setErrorMessage("Port must be a number.");
            }
        }
        this.setValid(valid);
        return valid;
    }
}

