/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.config;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProxySettings {
    public static final String INI_PROXY = "proxy";
    public static final String PROXY_HOST = "proxyHost";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_USEPROXY = "proxySet";
    public static final String PROXY_NOROXY_HOSTS = "http.nonProxyHosts";
    public static final String PROXY_NOROXY_APPLY = "applyNoProxy";
    private boolean useProxy;
    private String proxyHost;
    private int proxyPort;
    private String noProxy;
    private boolean applyNoProxy;

    public ProxySettings() {
        this(true, "", 0);
    }

    public ProxySettings(String host, int port) {
        this(true, host, port);
    }

    public ProxySettings(boolean use, String host, int port) {
        this(use, host, port, "", false);
    }

    public ProxySettings(boolean use, String host, int port, String noProxy, boolean applyNoProxy) {
        this.useProxy(use);
        this.setHost(host);
        this.setPort(port);
        this.setNoProxy(noProxy);
        this.setNoProxyApply(applyNoProxy);
    }

    public void useProxy(boolean use) {
        this.useProxy = use;
    }

    public void setHost(String host) {
        this.proxyHost = host;
    }

    public void setPort(int port) {
        this.proxyPort = port;
    }

    public void setNoProxy(String _hostsString) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(_hostsString, ";");
        while (tokenizer.hasMoreElements()) {
            String el = tokenizer.nextToken();
            buffer.append(el.trim());
            buffer.append(";");
        }
        this.noProxy = buffer.toString();
    }

    public void setNoProxyApply(boolean _applyNoProxy) {
        this.applyNoProxy = _applyNoProxy;
    }

    public boolean isProxySet() {
        return this.useProxy;
    }

    public String getHost() {
        return this.proxyHost;
    }

    public int getPort() {
        return this.proxyPort;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public boolean isApplyNoProxy() {
        return this.applyNoProxy;
    }

    public static ProxySettings loadFromPreferences(Preferences prefs) {
        ProxySettings proxy = null;
        boolean init = prefs.getBoolean("sapInitialized");
        if (!init) {
            String proxyLine = prefs.getString(INI_PROXY);
            String proxyExclude = prefs.getString(PROXY_NOROXY_HOSTS);
            proxy = ProxySettings.parse(proxyLine, proxyExclude);
            proxy.saveToPreferences(prefs);
            prefs.setValue("sapInitialized", true);
        } else {
            boolean useProxy = prefs.getBoolean(PROXY_USEPROXY);
            boolean applyNoProxy = prefs.getBoolean(PROXY_NOROXY_APPLY);
            String host = prefs.getString(PROXY_HOST);
            String proxyExclude = prefs.getString(PROXY_NOROXY_HOSTS);
            int port = prefs.getInt(PROXY_PORT);
            proxy = new ProxySettings(useProxy, host, port, proxyExclude, applyNoProxy);
        }
        return proxy;
    }

    public void saveToPreferences(Preferences prefs) {
        prefs.setValue(PROXY_USEPROXY, this.isProxySet());
        prefs.setValue(PROXY_HOST, this.getHost());
        prefs.setValue(PROXY_PORT, this.getPort());
        prefs.setValue(PROXY_NOROXY_HOSTS, this.getNoProxy());
        prefs.setValue(PROXY_NOROXY_APPLY, this.isApplyNoProxy());
    }

    public void saveToPreferences(IPreferenceStore store) {
        store.setValue(PROXY_USEPROXY, this.isProxySet());
        store.setValue(PROXY_HOST, this.getHost());
        store.setValue(PROXY_PORT, this.getPort());
        store.setValue(PROXY_NOROXY_HOSTS, this.getNoProxy());
        store.setValue(PROXY_NOROXY_APPLY, this.isApplyNoProxy());
    }

    public static ProxySettings parse(String proxyLine, String noProxyHosts) {
        String proxyHost = "";
        String proxyPort = "";
        boolean useProxy = false;
        int idx = proxyLine.lastIndexOf(58);
        if (idx > 0) {
            useProxy = true;
            proxyHost = proxyLine.substring(0, idx);
            proxyPort = proxyLine.substring(idx + 1);
        } else if (idx < 0) {
            if (proxyLine.length() == 0) {
                useProxy = false;
                proxyPort = "80";
            } else {
                useProxy = true;
                proxyHost = proxyLine;
                proxyPort = "80";
            }
        } else {
            useProxy = false;
            proxyPort = "80";
        }
        boolean applyNoProxy = noProxyHosts != null && !noProxyHosts.equals("");
        return new ProxySettings(useProxy, proxyHost, Integer.parseInt(proxyPort), noProxyHosts, applyNoProxy);
    }
}

