/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.tools.offlinedeploy.rdb.EntityResolverImpl;
import com.sap.engine.tools.offlinedeploy.rdb.FSExtractor;
import com.sap.engine.tools.offlinedeploy.rdb.OCDFactory;
import com.sap.engine.tools.offlinedeploy.rdb.ODeploymentException;
import com.sap.engine.tools.offlinedeploy.rdb.OWarningException;
import com.sap.engine.tools.offlinedeploy.rdb.OfflineComponentDeploy;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class OCDTool {
    private static final byte MODE_DEPLOY = 0;
    private static final byte MODE_JARDEPLOY = 1;
    private static final byte MODE_DIRDEPLOY = 2;
    private static final byte MODE_UNDEPLOY = 3;
    private static final byte MODE_JARUNDEPLOY = 4;
    private static final String INTERFACE = "interface";
    private static final String LIBRARY = "library";
    private static final String PRIMARY_LIBRARY = "primary-library";
    private static final String SERVICE = "service";
    private static final String PRIMARY_SERVICE = "primary-service";
    private static final String KERNEL = "kernel";
    private static final String ENGINE_KERNEL = "engine-kernel";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String BIG = "big-mama";
    private static final String FS = "FS";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_SDA = "META-INF/SAP_MANIFEST.MF";
    private static final boolean overwrite = true;
    private static final String TMPDIR = "./tmp";
    private static String propertiesFileName = "";
    private static String parsePropertiesFileName = "";
    private static String jarFileName = "";
    private static String componentName = "";
    private static byte componentType = (byte)-1;
    private static String sdaDir = "";
    private static String dtdDir = "./dtd";
    private static StringBuffer helpBuffer = null;
    private static byte mode;
    private static OfflineComponentDeploy ocd;
    private static StandardDOMParser domParser;

    private static void printUsage() {
        System.out.println(helpBuffer);
    }

    public static void main(String[] args) {
        try {
            long time = System.currentTimeMillis();
            if (!OCDTool.parseArgs(args)) {
                OCDTool.printUsage();
                return;
            }
            OCDTool.deleteDirectory(new File("./temp"), false);
            try {
                EntityResolverImpl er = new EntityResolverImpl(dtdDir);
                domParser = new StandardDOMParser();
                domParser.setEntityResolver((EntityResolver)er);
                domParser.setValidation(true);
            }
            catch (Exception exc) {
                System.out.println("ERROR: Can't initialize XML parser.");
                exc.printStackTrace();
                System.exit(11);
            }
            ocd = OCDFactory.createOfflineComponentDeploy(dtdDir, true);
            ocd.setConfigurationProperties(propertiesFileName);
            Properties props = null;
            if ((mode == 1 || mode == 2) && parsePropertiesFileName != "") {
                props = new Properties();
                props.load(new FileInputStream(new File(parsePropertiesFileName)));
            }
            if (mode == 1) {
                File jar = new File(jarFileName);
                String type = OCDTool.getComponentType(jar);
                if (type != null) {
                    componentType = OCDTool.parseComponentType(type);
                }
                if (componentType == -1) {
                    throw new RuntimeException("Component type for SDA: " + jar.getCanonicalFile() + " neither found nor passed as parameter!");
                }
                if (componentType == 105) {
                    OCDTool.deployBig(new File(jarFileName), props);
                } else if (componentType == 106) {
                    FSExtractor fse = new FSExtractor();
                    fse.extract(new File(jarFileName), propertiesFileName);
                } else {
                    ocd.deployComponent(jar, componentType, props);
                }
            } else if (mode == 2) {
                OCDTool.deployDir(sdaDir, props);
            } else if (mode == 3) {
                ocd.undeployComponent(componentName, componentType);
            } else if (mode == 4) {
                File jar = new File(jarFileName);
                String type = OCDTool.getComponentType(jar);
                if (type != null) {
                    componentType = OCDTool.parseComponentType(type);
                }
                if (componentType == -1) {
                    throw new RuntimeException("Component type for SDA: " + jar.getCanonicalFile() + " neither found nor passed as parameter!");
                }
                ocd.undeployComponent(jar, componentType);
            }
            System.out.println("Finished for: " + (System.currentTimeMillis() - time) + " ms.");
        }
        catch (ODeploymentException exc) {
            exc.printStackTrace();
        }
        catch (OWarningException exc) {
            exc.printStackTrace();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        System.exit(0);
    }

    private static byte parseComponentType(String type) {
        if (type.equalsIgnoreCase(INTERFACE)) {
            return 100;
        }
        if (type.equalsIgnoreCase(LIBRARY) || type.equalsIgnoreCase(PRIMARY_LIBRARY)) {
            return 101;
        }
        if (type.equalsIgnoreCase(SERVICE) || type.equalsIgnoreCase(PRIMARY_SERVICE)) {
            return 102;
        }
        if (type.equalsIgnoreCase(KERNEL) || type.equalsIgnoreCase(ENGINE_KERNEL)) {
            return 103;
        }
        if (type.equalsIgnoreCase(BOOTSTRAP)) {
            return 104;
        }
        if (type.equalsIgnoreCase(BIG)) {
            return 105;
        }
        if (type.equalsIgnoreCase(FS)) {
            return 106;
        }
        return -1;
    }

    private static void deployDir(String dirStr, Properties props) {
        FSExtractor fse = null;
        File directory = new File(dirStr);
        if (directory != null && directory.exists() && directory.isDirectory()) {
            File[] componentSDAs = directory.listFiles();
            int i = 0;
            while (i < componentSDAs.length) {
                try {
                    if (componentSDAs[i].getName().toLowerCase().endsWith(".sda")) {
                        String type = OCDTool.getComponentType(componentSDAs[i]);
                        if (type != null) {
                            componentType = OCDTool.parseComponentType(type);
                            if (componentType == 106) {
                                if (fse == null) {
                                    fse = new FSExtractor();
                                }
                                fse.extract(componentSDAs[i], propertiesFileName);
                            } else if (componentType != -1) {
                                ocd.deployComponent(componentSDAs[i], componentType, props);
                            } else {
                                System.out.println("WARNING: Unknown sda-type in Manifest or XML of " + componentSDAs[i].getName() + ": " + type);
                            }
                        } else {
                            System.out.println("WARNING: Can't find sda-type in Manifest or XML of " + componentSDAs[i].getName());
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("WARNING: Deploy of " + componentSDAs[i].getName() + " failed");
                    e.printStackTrace();
                }
                ++i;
            }
        } else if (directory == null) {
            System.out.println("ERROR: Internal Deployment Error");
        } else if (!directory.exists()) {
            System.out.println("ERROR: Component directory " + directory.getPath() + " doesn't exists");
        }
    }

    private static void deployBig(File jar, Properties props) throws IOException {
        OCDTool.extractJars(jar, TMPDIR);
        OCDTool.deployDir(TMPDIR, props);
        OCDTool.deleteDirectory(new File(TMPDIR), true);
    }

    private static String getComponentType(File componentSDA) throws Exception {
        String line = null;
        String res = null;
        res = OCDTool.getComponentTypeXML(componentSDA);
        if (res == null || OCDTool.parseComponentType(res) == -1) {
            ZipFile zip = new ZipFile(componentSDA);
            ZipEntry entry = zip.getEntry(MANIFEST);
            if (entry != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                while ((line = in.readLine()) != null) {
                    if (line.indexOf("sda-type:") == -1) continue;
                    res = line.substring(line.indexOf(":") + 1).trim();
                    break;
                }
                in.close();
            }
            zip.close();
        }
        return res;
    }

    private static String getComponentTypeXML(File componentSDA) throws Exception {
        String res = null;
        String entryName = OCDTool.getDescrXML(componentSDA);
        if (entryName != null) {
            Document document;
            Element root;
            NodeList list;
            ZipFile zip = new ZipFile(componentSDA);
            ZipEntry entry = zip.getEntry("META-INF/" + entryName);
            if (entry != null && (list = (root = (document = domParser.parse(zip.getInputStream(entry))).getDocumentElement()).getElementsByTagName("SoftwareType")).getLength() > 0) {
                res = OCDTool.getTextValue((Element)list.item(0));
            }
            zip.close();
        }
        return res;
    }

    private static String getDescrXML(File componentSDA) throws Exception {
        String line = null;
        String res = null;
        ZipFile zip = new ZipFile(componentSDA);
        ZipEntry entry = zip.getEntry(MANIFEST_SDA);
        if (entry != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
            while ((line = in.readLine()) != null) {
                if (line.indexOf("deployfile:") == -1) continue;
                res = line.substring(line.indexOf(":") + 1).trim();
                break;
            }
            in.close();
        }
        zip.close();
        return res;
    }

    private static boolean parseArgs(String[] args) {
        if (args.length <= 0) {
            return false;
        }
        if (args[0].equals("d")) {
            mode = 0;
        } else if (args[0].equals("u")) {
            mode = (byte)3;
        } else {
            return false;
        }
        int i = 1;
        while (i < args.length) {
            if (args[i].equals("-t")) {
                componentType = OCDTool.parseComponentType(args[++i]);
            } else if (args[i].equals("-j")) {
                jarFileName = args[++i];
            } else if (args[i].equals("-n")) {
                componentName = args[++i];
            } else if (args[i].equals("-p")) {
                propertiesFileName = args[++i];
            } else if (args[i].equals("-d")) {
                sdaDir = args[++i];
            } else if (args[i].equals("-x")) {
                dtdDir = args[++i];
            } else if (args[i].equals("-r")) {
                parsePropertiesFileName = args[++i];
            } else if (args[i].equals("-help") || args[i].equals("-?") || args[i].equals("/?")) {
                return false;
            }
            ++i;
        }
        if (mode == 0) {
            if ((args.length == 5 || args.length == 7 || args.length == 9 || args.length == 11) && jarFileName != "" && propertiesFileName != "") {
                mode = 1;
                return true;
            }
            if ((args.length == 5 || args.length == 7 || args.length == 9) && sdaDir != "" && propertiesFileName != "") {
                mode = (byte)2;
                return true;
            }
        } else if (mode == 3) {
            if ((args.length == 7 || args.length == 9) && componentType != -1 && componentName != "" && propertiesFileName != "") {
                mode = (byte)3;
                return true;
            }
            if ((args.length == 5 || args.length == 7 || args.length == 9) && jarFileName != "" && propertiesFileName != "") {
                mode = (byte)4;
                return true;
            }
        }
        return false;
    }

    private static void extractJars(File jar, String dir) throws IOException {
        File directory = new File(dir);
        if (directory != null && directory.exists() && directory.isDirectory()) {
            OCDTool.deleteDirectory(directory, false);
        }
        ZipFile zip = new ZipFile(jar);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            if (ze.getName().endsWith("/")) continue;
            OCDTool.storeEntry(new File(directory, ze.getName()), zip.getInputStream(ze));
        }
    }

    private static void deleteFile(File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteDirectory(File directoy, boolean deleteRoot) {
        if (directoy != null && directoy.isDirectory()) {
            File[] files = directoy.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    OCDTool.deleteDirectory(files[i], true);
                } else {
                    OCDTool.deleteFile(files[i]);
                }
                ++i;
            }
            if (deleteRoot) {
                OCDTool.deleteFile(directoy);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void storeEntry(File name, InputStream entry) {
        try {
            name.getParentFile().mkdirs();
            if (!name.isDirectory()) {
                int r;
                FileOutputStream fos = new FileOutputStream(name);
                byte[] buffer = new byte[1024];
                while ((r = entry.read(buffer)) != -1) {
                    void var4_5;
                    fos.write(buffer, 0, (int)var4_5);
                }
                entry.close();
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getTextValue(Element element) {
        Node node;
        String result = null;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            result = node.getNodeValue();
            result.trim();
            if (result.equals("") || result.equals("null")) {
                result = null;
            }
        }
        return result;
    }

    static {
        ocd = null;
        helpBuffer = new StringBuffer("Usage: OCDTool [-help|-?|/?] <d|u> [<-t service|library|interface|kernel|bootstrap>] [<-j SDAName>] [<-n componenName>] [<-d SDADir>] <-p paramFile> [<-x DTDDir>] [<-r parseParamFile>]\n");
        helpBuffer.append(" [-help|-?|/?]                                     - this help screen\n");
        helpBuffer.append(" <d|u>                                             - operation: (d)eploy|(u)ndeploy\n");
        helpBuffer.append(" [<-t service|libaray|interface|kernel|bootstrap>] - component type: service|library|interface|kernel|bootstrap\n");
        helpBuffer.append(" [<-j SDAName>]                                    - component SDA file\n");
        helpBuffer.append(" [<-n componenName>]                               - component name\n");
        helpBuffer.append(" [<-d SDADir>]                                     - component(s) SDA directory\n");
        helpBuffer.append(" <-p DBParamFile>                                  - DB connection properties file\n");
        helpBuffer.append(" [<-x DTDDir>]                                     - DTD directory\n");
        helpBuffer.append(" [<-r parseParamFile>]                             - parse connection properties file\n");
    }
}

