/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.generation.eclipse.deletion;

import com.sap.dictionary.tools.generation.dependency.DependencyService;
import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.dictionary.tools.generation.naming.NamingService;
import com.sap.ide.generationfwk.naming.NamingGenerationUnitFile;
import com.sap.ide.generationfwk.naming.NamingGenerationUnitJava;
import com.sap.ide.generationfwk.naming.NamingServiceBase;
import com.sap.ide.generationfwk.util.file.FileDeletionService;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.tc.logging.Location;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DeletionService {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$dictionary$tools$generation$eclipse$deletion$DeletionService == null ? (class$com$sap$dictionary$tools$generation$eclipse$deletion$DeletionService = DeletionService.class$("com.sap.dictionary.tools.generation.eclipse.deletion.DeletionService")) : class$com$sap$dictionary$tools$generation$eclipse$deletion$DeletionService).getName());
    private String mTargetPath = "";
    private NamingService mNamingService = null;
    private DependencyService mDependencyService = null;
    static /* synthetic */ Class class$com$sap$dictionary$tools$generation$eclipse$deletion$DeletionService;

    public DeletionService(IProject project) {
        this.setTargetPath(project.getLocation().toFile().getAbsolutePath());
        this.setNamingService(new NamingService(this.getTargetPath()));
        this.setDependencyService(new DependencyService(this.getTargetPath()));
    }

    private String doDeletionForSimpleType(String packageName, String simpleTypeName, boolean refresh) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getSimpleTypeNaming(packageName, simpleTypeName);
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doDeletionForSimpleTypeEnumClass(String packageName, String simpleTypeName, boolean refresh) {
        NamingGenerationUnitJava lNaming = this.getNamingService().getSimpleTypeEnumClassNaming(packageName, simpleTypeName);
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doDeletionForLogicalDictionary(String packageName, String logicalDictionaryName, boolean refresh) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getLogicalDictionaryNaming(packageName, logicalDictionaryName);
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doDeletionForStructure(String packageName, String structureName, boolean refresh) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getStructureNaming(packageName, structureName);
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doDeletionForPackagePointer(String packageName, boolean refresh) {
        NamingGenerationUnitJava lNaming = this.getNamingService().getPackagePointerNaming(packageName);
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doDeletionForSimpleTypesResource(String packageName, String language, boolean refresh) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getSimpleTypesResourceNaming(packageName, language);
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doDeletionForSimpleTypesDefaultResource(String packageName, boolean refresh) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getSimpleTypesDefaultResourceNaming(packageName);
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doDeletionForDbTable(String dbTableName, boolean refresh) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getDbTableNaming(dbTableName);
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    private String doDeletionForArchiveSdmDictionary(boolean refresh) {
        NamingGenerationUnitFile lNaming = this.getNamingService().getArchiveSdmDictionaryNaming();
        if (FileDeletionService.deleteFile((String)lNaming.getAbsoluteFilePath())) {
            if (refresh) {
                DeletionService.refreshResourceInBatch(new String[]{lNaming.getAbsoluteFilePath()});
            }
            return lNaming.getAbsoluteFilePath();
        }
        return null;
    }

    public final String deleteLogicalDictionary(DtLogicalDictionary logicalDictionary, boolean refresh) {
        return this.doDeletionForLogicalDictionary(logicalDictionary.getPackage(), logicalDictionary.getName(), refresh);
    }

    public final String deleteLogicalDictionary(String packageName, String logicalDictionaryName, boolean refresh) {
        return this.doDeletionForLogicalDictionary(packageName, logicalDictionaryName, refresh);
    }

    public final String deleteSimpleType(DtSimpleType simpleType, boolean refresh) {
        return this.doDeletionForSimpleType(simpleType.getPackage(), simpleType.getName(), refresh);
    }

    public final String deleteSimpleType(String packageName, String simpleTypeName, boolean refresh) {
        return this.doDeletionForSimpleType(packageName, simpleTypeName, refresh);
    }

    public final String deleteSimpleTypeEnumClass(DtSimpleType simpleType, boolean refresh) {
        return this.doDeletionForSimpleTypeEnumClass(simpleType.getPackage(), simpleType.getName(), refresh);
    }

    public final String deleteSimpleTypeEnumClass(String packageName, String simpleTypeName, boolean refresh) {
        return this.doDeletionForSimpleTypeEnumClass(packageName, simpleTypeName, refresh);
    }

    public final String deleteStructure(DtGeneralStructure structure, boolean refresh) {
        return this.doDeletionForStructure(structure.getPackage(), structure.getName(), refresh);
    }

    public final String deleteStructure(String packageName, String structureName, boolean refresh) {
        return this.doDeletionForStructure(packageName, structureName, refresh);
    }

    public final String deletePackagePointer(String packageName, boolean refresh) {
        return this.doDeletionForPackagePointer(packageName, refresh);
    }

    public final String deleteDbTable(DtDbTable dbTable, boolean refresh) {
        return this.doDeletionForDbTable(dbTable.getName(), refresh);
    }

    public final String deleteDbTable(String dbTableName, boolean refresh) {
        return this.doDeletionForDbTable(dbTableName, refresh);
    }

    public final String[] deleteArchive(DtLogicalDictionary[] logicalDictionaries, DtSimpleType[] simpleTypes, DtDbTable[] dbTables, boolean refresh) {
        String[] lFileNames = new String[]{};
        String lFileName = null;
        ArrayList<String> lFileList = new ArrayList<String>();
        lFileName = this.doDeletionForArchiveSdmDictionary(false);
        if (lFileName != null) {
            lFileList.add(lFileName);
        }
        int i = 0;
        while (i < logicalDictionaries.length) {
            lFileName = this.doDeletionForLogicalDictionary(logicalDictionaries[i].getPackage(), logicalDictionaries[i].getName(), false);
            if (lFileName != null) {
                lFileList.add(lFileName);
            }
            ++i;
        }
        HashSet<String> lUniquePackages = new HashSet<String>();
        int i2 = 0;
        while (i2 < simpleTypes.length) {
            if (!lUniquePackages.contains(simpleTypes[i2].getPackage())) {
                lUniquePackages.add(simpleTypes[i2].getPackage());
            }
            ++i2;
        }
        Iterator lIterator = lUniquePackages.iterator();
        String lPackage = null;
        while (lIterator.hasNext()) {
            lPackage = (String)lIterator.next();
            lFileName = this.doDeletionForSimpleTypesDefaultResource(lPackage, false);
            if (lFileName != null) {
                lFileList.add(lFileName);
            }
            HashSet lAlreadyDeleteForLanguages = new HashSet();
            String[] lAllLanguages = DeletionService.evaluateAvailableLanguages((MainDevelopmentObject[])simpleTypes);
            int i3 = 0;
            while (i3 < lAllLanguages.length) {
                lFileName = this.doDeletionForSimpleTypesResource(lPackage, lAllLanguages[i3], false);
                if (lFileName != null) {
                    lFileList.add(lFileName);
                }
                ++i3;
            }
        }
        lFileNames = new String[lFileList.size()];
        lFileNames = lFileList.toArray(lFileNames);
        if (refresh) {
            DeletionService.refreshResourceInBatch(lFileNames);
        }
        return lFileNames;
    }

    private static String[] evaluateAvailableLanguages(MainDevelopmentObject[] mdos) {
        HashSet<String> lUniqueLanguages = new HashSet<String>();
        String[] lAvailableLanguages = null;
        int i = 0;
        while (i < mdos.length) {
            lAvailableLanguages = mdos[i].getTextPool().getAvailableLanguages();
            int x = 0;
            while (x < lAvailableLanguages.length) {
                if (!lAvailableLanguages[x].equals("") && !lUniqueLanguages.contains(lAvailableLanguages[x])) {
                    lUniqueLanguages.add(lAvailableLanguages[x]);
                }
                ++x;
            }
            ++i;
        }
        lAvailableLanguages = new String[lUniqueLanguages.size()];
        return ((AbstractCollection)lUniqueLanguages).toArray(lAvailableLanguages);
    }

    private void setTargetPath(String targetPath) {
        this.mTargetPath = targetPath == null ? "" : NamingServiceBase.getNormalizedFileName((String)(targetPath + GenerationEclipse.getGenerationOutputPathInfix()));
    }

    private String getTargetPath() {
        return this.mTargetPath;
    }

    final DependencyService getDependencyService() {
        return this.mDependencyService;
    }

    private void setDependencyService(DependencyService dependencyService) {
        this.mDependencyService = dependencyService;
    }

    private NamingService getNamingService() {
        return this.mNamingService;
    }

    private void setNamingService(NamingService namingService) {
        this.mNamingService = namingService;
    }

    private static void refreshResource(String[] fileNames) {
        int i = 0;
        while (i < fileNames.length) {
            if (fileNames[i] != null && fileNames.length != 0) {
                try {
                    IFile lResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileNames[i]));
                    lResource.refreshLocal(0, null);
                }
                catch (Exception ex) {
                    TRACE_LOCATION.errorT("Refresh of resource " + fileNames[i] + " fails (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
                }
            }
            ++i;
        }
    }

    static final void refreshResourceInBatch(final String[] fileNames) {
        try {
            IWorkspaceRunnable lRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DeletionService.refreshResource(fileNames);
                }
            };
            ResourcesPlugin.getWorkspace().run(lRunnable, null);
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Exception occured while refreshing resources (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

