/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.generation.eclipse;

import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.dictionary.tools.generation.eclipse.GenerationPlugin;
import com.sap.ide.generationfwk.eclipse.GenerationFwkPlugin;
import com.sap.ide.generationfwk.eclipse.marker.GenerationMarker;
import com.sap.ide.generationfwk.naming.NamingServiceBase;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.generation.GenerationObjectChangedCache;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryMDOEnum;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.tc.logging.Location;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class GenerationVisitor
implements IResourceVisitor {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$dictionary$tools$generation$eclipse$GenerationVisitor == null ? (class$com$sap$dictionary$tools$generation$eclipse$GenerationVisitor = GenerationVisitor.class$("com.sap.dictionary.tools.generation.eclipse.GenerationVisitor")) : class$com$sap$dictionary$tools$generation$eclipse$GenerationVisitor).getName());
    GenerationEclipse mGeneration = null;
    IProgressMonitor mProgessMonitor = null;
    static /* synthetic */ Class class$com$sap$dictionary$tools$generation$eclipse$GenerationVisitor;

    public GenerationVisitor(IProgressMonitor monitor, boolean incremental) {
        this.setProgressMonitor(monitor);
        this.setGeneration(new GenerationEclipse(monitor));
        this.getGeneration().setIncremental(incremental);
        this.getGeneration().refreshConfiguration();
    }

    public boolean visit(IResource resource) throws CoreException {
        GenerationObjectChangedCache lObjectChangedCache = GenerationEclipse.getObjectChangedCacheForProject(resource.getProject().getName());
        if (this.getProgressMonitor().isCanceled()) {
            lObjectChangedCache.setValid(true);
            this.getProgressMonitor().done();
            throw new OperationCanceledException();
        }
        if (resource.getType() == 4) {
            lObjectChangedCache.evaluateConsumers();
            if (this.getGeneration().isIncremental()) {
                if (lObjectChangedCache.isValid()) {
                    this.getGeneration().setObjectChangedCache(lObjectChangedCache);
                    lObjectChangedCache.setValid(false, "com.sap.dictionary.tools.generation.GenerationBuilder");
                } else {
                    this.getGeneration().getObjectChangedCache().clear();
                }
            } else {
                this.getGeneration().setTargetPath(resource.getProject().getLocation().toFile().getAbsolutePath());
                this.getGeneration().deleteOutputFolderContent();
                lObjectChangedCache.setValid(false, "com.sap.dictionary.tools.generation.GenerationBuilder");
                this.getGeneration().getObjectChangedCache().clear();
            }
            return true;
        }
        if (resource.getType() != 1) {
            return true;
        }
        if (resource.getFileExtension() == null) {
            return true;
        }
        if (resource.getFileExtension().equals(DtDictionaryMDOEnum.DTSIMPLETYPE.getFileExtension())) {
            if (!GenerationEclipse.isResourceInSourceFolder(resource)) {
                return false;
            }
            return this.visitSimpleType(resource);
        }
        if (resource.getFileExtension().equals(DtDictionaryMDOEnum.DTGENERALSTRUCTURE.getFileExtension())) {
            if (!GenerationEclipse.isResourceInSourceFolder(resource)) {
                return false;
            }
            return this.visitStructure(resource);
        }
        if (resource.getFileExtension().equals(DtDictionaryMDOEnum.DTDBTABLE.getFileExtension())) {
            if (!GenerationEclipse.isResourceInSourceFolder(resource)) {
                return false;
            }
            return this.visitDbTable(resource);
        }
        return !resource.getFileExtension().equals(DtDictionaryMDOEnum.DTLOGICALDICTIONARY.getFileExtension()) || GenerationEclipse.isResourceInSourceFolder(resource);
    }

    private boolean visitSimpleType(IResource resource) throws CoreException {
        this.getGeneration().setResource(resource);
        GenerationMarker.deleteProblemMarkers((String)GenerationPlugin.getPluginId(), (IResource)resource);
        DtSimpleType lSimpleType = null;
        IProject lProject = resource.getProject();
        try {
            MetamodelManager lMetamodelManager = MetamodelManager.getMetamodelManager((String)lProject.getName());
            if (lMetamodelManager == null) {
                this.getGeneration().setResource(null);
                return true;
            }
            DtDictionaryRoot lDictionaryRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)lMetamodelManager.getMetamodel());
            lSimpleType = lDictionaryRoot.getSimpleType(this.getPackageName(resource, GenerationFwkPlugin.getJavaProject((IProject)lProject)), NamingServiceBase.getFileNameWithoutExtension((String)resource.getName()));
        }
        catch (Exception ex) {
            this.getGeneration().printMessage(2, "Metadata could not be read!");
            this.getGeneration().setResource(null);
            return false;
        }
        this.getGeneration().setTargetPath(resource.getProject().getLocation().toFile().getAbsolutePath());
        this.getGeneration().generatePersistentSimpleType(lSimpleType, false, true, true, false);
        this.getGeneration().setResource(null);
        return false;
    }

    private boolean visitStructure(IResource resource) throws CoreException {
        this.getGeneration().setResource(resource);
        GenerationMarker.deleteProblemMarkers((String)GenerationPlugin.getPluginId(), (IResource)resource);
        DtGeneralStructure lStructure = null;
        IProject lProject = resource.getProject();
        try {
            MetamodelManager lMetamodelManager = MetamodelManager.getMetamodelManager((String)lProject.getName());
            if (lMetamodelManager == null) {
                this.getGeneration().setResource(null);
                return true;
            }
            DtDictionaryRoot lDictionaryRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)lMetamodelManager.getMetamodel());
            lStructure = lDictionaryRoot.getStructure(this.getPackageName(resource, GenerationFwkPlugin.getJavaProject((IProject)lProject)), NamingServiceBase.getFileNameWithoutExtension((String)resource.getName()));
        }
        catch (Exception ex) {
            this.getGeneration().printMessage(2, "Metadata could not be read!");
            this.getGeneration().setResource(null);
            return false;
        }
        this.getGeneration().setTargetPath(resource.getProject().getLocation().toFile().getAbsolutePath());
        this.getGeneration().generatePersistentStructure(lStructure, false, true, true, false);
        this.getGeneration().setResource(null);
        return false;
    }

    private boolean visitDbTable(IResource resource) throws CoreException {
        this.getGeneration().setResource(resource);
        GenerationMarker.deleteProblemMarkers((String)GenerationPlugin.getPluginId(), (IResource)resource);
        DtDbTable lDbTable = null;
        IProject lProject = resource.getProject();
        try {
            MetamodelManager lMetamodelManager = MetamodelManager.getMetamodelManager((String)lProject.getName());
            if (lMetamodelManager == null) {
                this.getGeneration().setResource(null);
                return true;
            }
            DtDictionaryRoot lDictionaryRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)lMetamodelManager.getMetamodel());
            lDbTable = lDictionaryRoot.getTable(this.getPackageName(resource, GenerationFwkPlugin.getJavaProject((IProject)lProject)), NamingServiceBase.getFileNameWithoutExtension((String)resource.getName()));
        }
        catch (Exception ex) {
            this.getGeneration().printMessage(2, "Metadata could not be read!");
            this.getGeneration().setResource(null);
            return false;
        }
        this.getGeneration().setTargetPath(resource.getProject().getLocation().toFile().getAbsolutePath());
        this.getGeneration().generatePersistentDbTable(lDbTable, false, true, true, false);
        this.getGeneration().setResource(null);
        return false;
    }

    private boolean visitLogicalDictionary(IResource resource) throws CoreException {
        return false;
    }

    private String getPackageName(IResource resource, IJavaProject lJavaProject) throws JavaModelException {
        IPackageFragment lPackageFragment = lJavaProject.findPackageFragment(resource.getParent().getFullPath());
        if (lPackageFragment == null) {
            return "";
        }
        String lPackage = lPackageFragment.getElementName();
        if (lPackage == null) {
            return "";
        }
        return lPackage;
    }

    private void setGeneration(GenerationEclipse generation) {
        this.mGeneration = generation;
    }

    private GenerationEclipse getGeneration() {
        return this.mGeneration;
    }

    private void setProgressMonitor(IProgressMonitor monitor) {
        this.mProgessMonitor = monitor;
    }

    private IProgressMonitor getProgressMonitor() {
        return this.mProgessMonitor;
    }

    public final void cleanup() {
        this.getGeneration().cleanup();
        this.setGeneration(null);
        this.setProgressMonitor(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

