/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.generation.eclipse;

import com.sap.dictionary.tools.generation.Generation;
import com.sap.dictionary.tools.generation.dependency.DependencyService;
import com.sap.dictionary.tools.generation.eclipse.GenerationPlugin;
import com.sap.ide.generationfwk.configuration.GenerationConfigurationBase;
import com.sap.ide.generationfwk.eclipse.GenerationFwkPlugin;
import com.sap.ide.generationfwk.eclipse.configuration.GenerationConfiguration;
import com.sap.ide.generationfwk.eclipse.marker.GenerationMarker;
import com.sap.ide.generationfwk.logging.ILogging;
import com.sap.ide.generationfwk.naming.NamingGenerationUnitFile;
import com.sap.ide.metamodel.core.generation.GenerationObjectChangedCache;
import com.sap.ide.metamodel.core.generation.GenerationObjectRelationEvaluator;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class GenerationEclipse
extends Generation {
    private static final Location TRACE_LOCATION = Location.getLocation((String)(class$com$sap$dictionary$tools$generation$eclipse$GenerationEclipse == null ? (class$com$sap$dictionary$tools$generation$eclipse$GenerationEclipse = GenerationEclipse.class$("com.sap.dictionary.tools.generation.eclipse.GenerationEclipse")) : class$com$sap$dictionary$tools$generation$eclipse$GenerationEclipse).getName());
    private static final String EXTENSION_POINT_ID_DD_GENERATION = "com.sap.dictionary.tools.generation.GenerationPluginDataProvider";
    private IProgressMonitor mProgessMonitor = new NullProgressMonitor();
    private int mProgress = 0;
    private IResource mResource = null;
    private GenerationObjectChangedCache mObjectChangedCache = null;
    private GenerationObjectRelationEvaluator mObjectRelationEvaluator = new GenerationObjectRelationEvaluator();
    static /* synthetic */ Class class$com$sap$dictionary$tools$generation$eclipse$GenerationEclipse;

    public GenerationEclipse(IProgressMonitor monitor) {
        super(2);
        this.setExtensionId(EXTENSION_POINT_ID_DD_GENERATION);
        this.setConfiguration((GenerationConfigurationBase)new GenerationConfiguration(GenerationFwkPlugin.getInstance().getGenerationDataProvider(this.getExtensionId()), (ILogging)this));
        this.setProgressMonitor(monitor);
        GenerationMarker.deleteProblemMarkers((String)GenerationPlugin.getPluginId(), (IResource)ResourcesPlugin.getWorkspace().getRoot());
    }

    private String[] generatePersistentSimpleType(DtSimpleType simpleType, boolean updateEnvironment, boolean check, boolean refresh) {
        if (this.isIncremental() && this.getObjectChangedCache().isEmpty()) {
            this.updateGenerationObjectCache(simpleType.getRoot().getMetamodel().getName());
        }
        ArrayList<String> lOutputFileList = new ArrayList<String>();
        String[] lOutputFileNames = new String[]{};
        try {
            lOutputFileNames = this.generatePersistentSimpleType(simpleType, check);
            int z = 0;
            while (z < lOutputFileNames.length) {
                lOutputFileList.add(lOutputFileNames[z]);
                ++z;
            }
            if (updateEnvironment) {
                if (this.isIncremental() && !Generation.isErrorIndicator()) {
                    this.getObjectChangedCache().removeMainDevObject(simpleType.getKey());
                }
                lOutputFileNames = this.generatePersistentEnvironment((MainDevelopmentObject)simpleType, check, false);
                int z2 = 0;
                while (z2 < lOutputFileNames.length) {
                    lOutputFileList.add(lOutputFileNames[z2]);
                    ++z2;
                }
            }
            lOutputFileNames = new String[lOutputFileList.size()];
            lOutputFileNames = lOutputFileList.toArray(lOutputFileNames);
            if (refresh) {
                this.refreshResourceInBatch(lOutputFileNames);
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Generation of simple type " + simpleType.getName() + " is determined with an exception (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            this.printMessage(2, "Generation aborted with exception " + ex.getMessage() + " (" + ex.toString() + ")");
        }
        catch (Error er) {
            TRACE_LOCATION.errorT("Generation of simple type " + simpleType.getName() + " is determined with an error (" + er.getClass().getName() + ": " + er.getMessage() + ")", new Object[]{er});
            this.printMessage(2, "Generation aborted with error " + er.getMessage() + " (" + er.toString() + ")");
        }
        return lOutputFileNames;
    }

    public final String[] generatePersistentSimpleType(final DtSimpleType simpleType, final boolean updateEnvironment, final boolean check, final boolean refresh, boolean busyIndicator) {
        final ArrayList<String> lOutputFileList = new ArrayList<String>();
        if (busyIndicator) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    String[] lOutputFileNames = GenerationEclipse.this.generatePersistentSimpleType(simpleType, updateEnvironment, check, refresh);
                    lOutputFileList.addAll(Arrays.asList(lOutputFileNames));
                }
            });
        } else {
            String[] lOutputFileNames = this.generatePersistentSimpleType(simpleType, updateEnvironment, check, refresh);
            lOutputFileList.addAll(Arrays.asList(lOutputFileNames));
        }
        String[] lReturnOutputFileNames = new String[lOutputFileList.size()];
        lReturnOutputFileNames = lOutputFileList.toArray(lReturnOutputFileNames);
        return lReturnOutputFileNames;
    }

    private String generateTransientSimpleTypeSchema(DtSimpleType simpleType, boolean check) {
        String lOutputString = null;
        try {
            lOutputString = this.generateTransientSimpleTypeXSD(simpleType, check);
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Generation of simple type schema " + simpleType.getName() + " is determined with an exception (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            this.printMessage(2, "Generation aborted with exception " + ex.getMessage() + " (" + ex.toString() + ")");
        }
        catch (Error er) {
            TRACE_LOCATION.errorT("Generation of simple type schema " + simpleType.getName() + " is determined with an error (" + er.getClass().getName() + ": " + er.getMessage() + ")", new Object[]{er});
            this.printMessage(2, "Generation aborted with error " + er.getMessage() + " (" + er.toString() + ")");
        }
        return lOutputString;
    }

    public final String generateTransientSimpleTypeSchema(final DtSimpleType simpleType, final boolean check, boolean busyIndicator) {
        final StringBuffer lStringBuffer = new StringBuffer();
        if (busyIndicator) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    lStringBuffer.append(GenerationEclipse.this.generateTransientSimpleTypeSchema(simpleType, check));
                }
            });
        } else {
            lStringBuffer.append(this.generateTransientSimpleTypeSchema(simpleType, check));
        }
        return lStringBuffer.toString();
    }

    private String generateTransientSimpleTypeSchemaDefault(DtSimpleType simpleType, boolean check) {
        String lOutputString = null;
        try {
            lOutputString = this.generateTransientSimpleTypeXSDDefault(simpleType, check);
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Generation of default schema for simple type " + simpleType.getName() + " is determined with an exception (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            this.printMessage(2, "Generation aborted with exception " + ex.getMessage() + " (" + ex.toString() + ")");
        }
        catch (Error er) {
            TRACE_LOCATION.errorT("Generation of default schema for simple type " + simpleType.getName() + " is determined with an error (" + er.getClass().getName() + ": " + er.getMessage() + ")", new Object[]{er});
            this.printMessage(2, "Generation aborted with error " + er.getMessage() + " (" + er.toString() + ")");
        }
        return lOutputString;
    }

    public final String generateTransientSimpleTypeSchemaDefault(final DtSimpleType simpleType, final boolean check, boolean busyIndicator) {
        final StringBuffer lStringBuffer = new StringBuffer();
        if (busyIndicator) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    lStringBuffer.append(GenerationEclipse.this.generateTransientSimpleTypeSchemaDefault(simpleType, check));
                }
            });
        } else {
            lStringBuffer.append(this.generateTransientSimpleTypeSchemaDefault(simpleType, check));
        }
        return lStringBuffer.toString();
    }

    private String[] generatePersistentStructure(DtGeneralStructure structure, boolean updateEnvironment, boolean check, boolean refresh) {
        if (this.isIncremental() && this.getObjectChangedCache().isEmpty()) {
            this.updateGenerationObjectCache(structure.getRoot().getMetamodel().getName());
        }
        ArrayList<String> lOutputFileList = new ArrayList<String>();
        String[] lOutputFileNames = new String[]{};
        try {
            lOutputFileNames = this.generatePersistentStructure(structure, check);
            int z = 0;
            while (z < lOutputFileNames.length) {
                lOutputFileList.add(lOutputFileNames[z]);
                ++z;
            }
            if (updateEnvironment) {
                if (this.isIncremental() && !Generation.isErrorIndicator()) {
                    this.getObjectChangedCache().removeMainDevObject(structure.getKey());
                }
                lOutputFileNames = this.generatePersistentEnvironment((MainDevelopmentObject)structure, check, false);
                int z2 = 0;
                while (z2 < lOutputFileNames.length) {
                    lOutputFileList.add(lOutputFileNames[z2]);
                    ++z2;
                }
            }
            lOutputFileNames = new String[lOutputFileList.size()];
            lOutputFileNames = lOutputFileList.toArray(lOutputFileNames);
            if (refresh) {
                this.refreshResourceInBatch(lOutputFileNames);
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Generation of structure " + structure.getName() + " is determined with an exception (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            this.printMessage(2, "Generation aborted with exception " + ex.getMessage() + " (" + ex.toString() + ")");
        }
        catch (Error er) {
            TRACE_LOCATION.errorT("Generation of structure " + structure.getName() + " is determined with an error (" + er.getClass().getName() + ": " + er.getMessage() + ")", new Object[]{er});
            this.printMessage(2, "Generation aborted with error " + er.getMessage() + " (" + er.toString() + ")");
        }
        return lOutputFileNames;
    }

    public final String[] generatePersistentStructure(final DtGeneralStructure structure, final boolean updateEnvironment, final boolean check, final boolean refresh, boolean busyIndicator) {
        final ArrayList<String> lOutputFileList = new ArrayList<String>();
        if (busyIndicator) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    String[] lOutputFileNames = GenerationEclipse.this.generatePersistentStructure(structure, updateEnvironment, check, refresh);
                    lOutputFileList.addAll(Arrays.asList(lOutputFileNames));
                }
            });
        } else {
            String[] lOutputFileNames = this.generatePersistentStructure(structure, updateEnvironment, check, refresh);
            lOutputFileList.addAll(Arrays.asList(lOutputFileNames));
        }
        String[] lReturnOutputFileNames = new String[lOutputFileList.size()];
        lReturnOutputFileNames = lOutputFileList.toArray(lReturnOutputFileNames);
        return lReturnOutputFileNames;
    }

    private String[] generatePersistentDbTable(DtDbTable dbTable, boolean updateEnvironment, boolean check, boolean refresh) {
        if (this.isIncremental() && this.getObjectChangedCache().isEmpty()) {
            this.updateGenerationObjectCache(dbTable.getRoot().getMetamodel().getName());
        }
        ArrayList<String> lOutputFileList = new ArrayList<String>();
        String[] lOutputFileNames = new String[]{};
        String lOutputFileName = null;
        try {
            lOutputFileName = this.generatePersistentDbTable(dbTable, check);
            if (lOutputFileName != null && lOutputFileName.length() > 0) {
                lOutputFileList.add(lOutputFileName);
            }
            if (updateEnvironment) {
                if (this.isIncremental() && !Generation.isErrorIndicator()) {
                    this.getObjectChangedCache().removeMainDevObject(dbTable.getKey());
                }
                lOutputFileNames = this.generatePersistentEnvironment((MainDevelopmentObject)dbTable, check, false);
                int z = 0;
                while (z < lOutputFileNames.length) {
                    lOutputFileList.add(lOutputFileNames[z]);
                    ++z;
                }
            }
            lOutputFileNames = new String[lOutputFileList.size()];
            lOutputFileNames = lOutputFileList.toArray(lOutputFileNames);
            if (refresh) {
                GenerationEclipse.refreshResource(new String[]{lOutputFileName});
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Generation of db table " + dbTable.getName() + " is determined with an exception (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            this.printMessage(2, "Generation aborted with exception " + ex.getMessage() + " (" + ex.toString() + ")");
        }
        catch (Error er) {
            TRACE_LOCATION.errorT("Generation of db table " + dbTable.getName() + " is determined with an error (" + er.getClass().getName() + ": " + er.getMessage() + ")", new Object[]{er});
            this.printMessage(2, "Generation aborted with error " + er.getMessage() + " (" + er.toString() + ")");
        }
        return lOutputFileNames;
    }

    public final String[] generatePersistentDbTable(final DtDbTable dbTable, final boolean updateEnvironment, final boolean check, final boolean refresh, boolean busyIndicator) {
        final ArrayList<String> lOutputFileList = new ArrayList<String>();
        if (busyIndicator) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    String[] lOutputFileNames = GenerationEclipse.this.generatePersistentDbTable(dbTable, updateEnvironment, check, refresh);
                    lOutputFileList.addAll(Arrays.asList(lOutputFileNames));
                }
            });
        } else {
            String[] lOutputFileNames = this.generatePersistentDbTable(dbTable, updateEnvironment, check, refresh);
            lOutputFileList.addAll(Arrays.asList(lOutputFileNames));
        }
        String[] lReturnOutputFileNames = new String[lOutputFileList.size()];
        lReturnOutputFileNames = lOutputFileList.toArray(lReturnOutputFileNames);
        return lReturnOutputFileNames;
    }

    private String[] generatePersistentArchive(String archiveName, String vendorName, String dcName, DtLogicalDictionary[] logicalDictionaries, DtSimpleType[] simpleTypes, DtGeneralStructure[] structures, DtDbTable[] dbTables, boolean check, boolean refresh) {
        String[] lOutputFileNames = new String[]{};
        try {
            lOutputFileNames = this.generatePersistentArchive(archiveName, vendorName, dcName, logicalDictionaries, simpleTypes, structures, dbTables, new String[0], check);
            if (refresh) {
                GenerationEclipse.refreshResource(lOutputFileNames);
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Generation of archive files determined with an exception (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            this.printMessage(2, "Generation aborted with exception " + ex.getMessage() + " (" + ex.toString() + ")");
        }
        catch (Error er) {
            TRACE_LOCATION.errorT("Generation of archive files determined with an error (" + er.getClass().getName() + ": " + er.getMessage() + ")", new Object[]{er});
            this.printMessage(2, "Generation aborted with error " + er.getMessage() + " (" + er.toString() + ")");
        }
        return lOutputFileNames;
    }

    public final String[] generatePersistentArchive(final String archiveName, final String vendorName, final String dcName, final DtLogicalDictionary[] logicalDictionaries, final DtSimpleType[] simpleTypes, final DtGeneralStructure[] structures, final DtDbTable[] dbTables, final boolean check, final boolean refresh, boolean busyIndicator) {
        final ArrayList<String> lOutputFileList = new ArrayList<String>();
        if (busyIndicator) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    String[] lOutputFileNames = GenerationEclipse.this.generatePersistentArchive(archiveName, vendorName, dcName, logicalDictionaries, simpleTypes, structures, dbTables, check, refresh);
                    lOutputFileList.addAll(Arrays.asList(lOutputFileNames));
                }
            });
        } else {
            String[] lOutputFileNames = this.generatePersistentArchive(archiveName, vendorName, dcName, logicalDictionaries, simpleTypes, structures, dbTables, check, refresh);
            lOutputFileList.addAll(Arrays.asList(lOutputFileNames));
        }
        String[] lReturnOutputFileNames = new String[lOutputFileList.size()];
        lReturnOutputFileNames = lOutputFileList.toArray(lReturnOutputFileNames);
        return lReturnOutputFileNames;
    }

    private String[] generatePersistentEnvironment(MainDevelopmentObject mainDevObject, boolean check, boolean refresh) {
        boolean lIsIncrementalGeneration = this.isIncremental();
        this.setIncremental(true);
        if (this.getObjectChangedCache().isEmpty()) {
            this.updateGenerationObjectCache(mainDevObject.getRoot().getMetamodel().getName());
        }
        HashSet lRelatedMainDevObjects = this.getObjectRelationEvaluator().evaluateRelatedMainDevObjects((DevelopmentObject)mainDevObject);
        String[] lOutputFileNames = new String[]{};
        String lOutputFileName = null;
        ArrayList<String> lOutputFileList = new ArrayList<String>();
        Iterator lIterator = lRelatedMainDevObjects.iterator();
        MainDevelopmentObject lReferencedMainDevObject = null;
        while (lIterator.hasNext()) {
            int z;
            lReferencedMainDevObject = mainDevObject.getRoot().getMetamodel().getObjectFromKey((DevelopmentObjectKey)lIterator.next()).getMDO();
            if (lReferencedMainDevObject.equals(mainDevObject)) continue;
            if (lReferencedMainDevObject instanceof DtSimpleType) {
                lOutputFileNames = this.generatePersistentSimpleType((DtSimpleType)lReferencedMainDevObject, check);
                z = 0;
                while (z < lOutputFileNames.length) {
                    lOutputFileList.add(lOutputFileNames[z]);
                    ++z;
                }
                continue;
            }
            if (lReferencedMainDevObject instanceof DtGeneralStructure) {
                lOutputFileNames = this.generatePersistentStructure((DtGeneralStructure)lReferencedMainDevObject, check);
                z = 0;
                while (z < lOutputFileNames.length) {
                    lOutputFileList.add(lOutputFileNames[z]);
                    ++z;
                }
                continue;
            }
            if (!(lReferencedMainDevObject instanceof DtDbTable) || (lOutputFileName = this.generatePersistentDbTable((DtDbTable)lReferencedMainDevObject, check)) == null || lOutputFileName.length() <= 0) continue;
            lOutputFileList.add(lOutputFileName);
        }
        lOutputFileNames = new String[lOutputFileList.size()];
        lOutputFileNames = lOutputFileList.toArray(lOutputFileNames);
        if (refresh) {
            this.refreshResourceInBatch(lOutputFileNames);
        }
        this.setIncremental(lIsIncrementalGeneration);
        return lOutputFileNames;
    }

    public final void printMessage(int category, String messageText) {
        try {
            switch (category) {
                case 1: {
                    if (this.isLogging()) {
                        this.getProgressMonitor().subTask(messageText);
                        ++this.mProgress;
                        this.getProgressMonitor().worked(this.mProgress);
                    }
                    break;
                }
                case 3: {
                    if (this.isLogging()) {
                        GenerationMarker.createMarker((String)GenerationPlugin.getPluginId(), (IResource)this.getResource(), (int)1, (String)(this.getGenerationConfiguration().getId() + ": " + messageText));
                        this.getProgressMonitor().subTask(messageText);
                    }
                    break;
                }
                case 2: {
                    this.setErrorIndicator(true);
                    GenerationMarker.createMarker((String)GenerationPlugin.getPluginId(), (IResource)this.getResource(), (int)2, (String)(this.getGenerationConfiguration().getId() + ": " + messageText));
                    this.getProgressMonitor().subTask(messageText);
                    break;
                }
                default: {
                    if (this.isLogging()) {
                        this.getProgressMonitor().subTask(messageText);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Log entry could not created with message \"" + this.getGenerationConfiguration().getId() + ": " + messageText + "\" (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
        }
    }

    public final void setTargetPath(String targetPath) {
        super.setTargetPath(targetPath + GenerationEclipse.getGenerationOutputPathInfix());
    }

    public final DependencyService getDependencyService() {
        return super.getDependencyService();
    }

    private void setProgressMonitor(IProgressMonitor monitor) {
        if (monitor != null) {
            this.mProgessMonitor = monitor;
        }
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.mProgessMonitor;
    }

    public final void setResource(IResource resource) {
        this.mResource = resource;
    }

    public final IResource getResource() {
        return this.mResource;
    }

    static final boolean isResourceInSourceFolder(IResource resource) {
        IClasspathEntry[] lClasspaths = null;
        try {
            IJavaProject lJavaProject = GenerationFwkPlugin.getJavaProject((IProject)resource.getProject());
            lClasspaths = lJavaProject.getResolvedClasspath(false);
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Classpath of project " + resource.getProject().getName() + " could not be read (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            return false;
        }
        IPath lSourceInfix = null;
        int i = 0;
        while (i < lClasspaths.length) {
            if (lClasspaths[i].getEntryKind() == 3) {
                lSourceInfix = lClasspaths[i].getPath().removeFirstSegments(1);
                if (lSourceInfix.hasTrailingSeparator()) {
                    lSourceInfix = lSourceInfix.removeTrailingSeparator();
                }
                if (!lSourceInfix.isEmpty()) {
                    if (resource.getProjectRelativePath().toString().startsWith(lSourceInfix.toString())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static final String getGenerationOutputPathInfix() {
        IPreferenceStore lPreferenceStore = GenerationPlugin.getInstance().getPreferenceStore();
        String lInfix = lPreferenceStore.getString("sapDdGenOutputPathInfix");
        if (lInfix == null) {
            return "/gen_ddic";
        }
        if ((lInfix = lInfix.trim()).length() > 0) {
            if (!lInfix.startsWith(new Character('/').toString())) {
                return '/' + lInfix;
            }
            return lInfix;
        }
        return lInfix;
    }

    public static final boolean isGenerationCompiledTemplates() {
        IPreferenceStore lPreferenceStore = GenerationPlugin.getInstance().getPreferenceStore();
        return lPreferenceStore.getBoolean("sapDdGenCompiledTemplates");
    }

    final GenerationObjectChangedCache getObjectChangedCache() {
        if (this.mObjectChangedCache == null) {
            this.mObjectChangedCache = new GenerationObjectChangedCache();
        }
        return this.mObjectChangedCache;
    }

    final void setObjectChangedCache(GenerationObjectChangedCache objectChangedCache) {
        this.mObjectChangedCache = objectChangedCache;
    }

    private GenerationObjectChangedCache updateGenerationObjectCache(String projectName) {
        GenerationObjectChangedCache lObjectChangedCache = GenerationEclipse.getObjectChangedCacheForProject(projectName);
        if (lObjectChangedCache.isValid()) {
            this.setObjectChangedCache(lObjectChangedCache);
        } else {
            lObjectChangedCache.clear();
            this.setObjectChangedCache(lObjectChangedCache);
        }
        return this.getObjectChangedCache();
    }

    protected final boolean isGeneration(DevelopmentObject devObject) {
        if (devObject.getMDO().originatesInArchive()) {
            return false;
        }
        if (this.getObjectChangedCache().isEmpty()) {
            return false;
        }
        HashSet lRelatedMainDevObjects = this.getObjectRelationEvaluator().evaluateRelatedMainDevObjects(devObject);
        Iterator lIterator = lRelatedMainDevObjects.iterator();
        while (lIterator.hasNext()) {
            if (!this.getObjectChangedCache().isMainDevObjectModified((DevelopmentObjectKey)lIterator.next())) continue;
            return true;
        }
        return false;
    }

    public final GenerationObjectRelationEvaluator getObjectRelationEvaluator() {
        return this.mObjectRelationEvaluator;
    }

    private void setObjectRelationEvaluator(GenerationObjectRelationEvaluator objectRelationEvaluator) {
        this.mObjectRelationEvaluator = objectRelationEvaluator;
    }

    private static void refreshResource(String[] fileNames) {
        if (fileNames == null || fileNames.length == 0) {
            return;
        }
        File lFile = null;
        IFile lResource = null;
        int i = 0;
        while (i < fileNames.length) {
            block8: {
                if (fileNames[i] != null && fileNames.length != 0) {
                    try {
                        lFile = new File(fileNames[i]);
                        if (lFile.isFile()) {
                            lResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileNames[i]));
                            lResource.refreshLocal(0, null);
                        } else {
                            if (!lFile.isDirectory()) break block8;
                            lResource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(fileNames[i]));
                            lResource.refreshLocal(2, null);
                        }
                        lResource.setDerived(true);
                    }
                    catch (Exception ex) {
                        TRACE_LOCATION.errorT("Refresh of resource " + fileNames[i] + " fails (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
                    }
                }
            }
            ++i;
        }
    }

    private void refreshResourceInBatch(final String[] fileNames) {
        if (fileNames == null || fileNames.length == 0) {
            return;
        }
        try {
            IWorkspaceRunnable lRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    GenerationEclipse.refreshResource(fileNames);
                }
            };
            ResourcesPlugin.getWorkspace().run(lRunnable, null);
        }
        catch (Exception ex) {
            TRACE_LOCATION.errorT("Exception occured while refreshing resources (" + ex.getClass().getName() + ": " + ex.getMessage() + ")", new Object[]{ex});
            this.printMessage(3, "Refresh on resources failed with exception " + ex.getClass().getName() + "!");
        }
    }

    protected final void showCheckResult(ArrayList infoMessages, ArrayList warningMessages, ArrayList errorMessages) {
        int i;
        super.showCheckResult(infoMessages, warningMessages, errorMessages);
        if (infoMessages != null) {
            i = 0;
            while (i < infoMessages.size()) {
                this.printMessage(1, ((String)infoMessages.get(i)).trim());
                ++i;
            }
        }
        if (warningMessages != null) {
            i = 0;
            while (i < warningMessages.size()) {
                this.printMessage(3, ((String)warningMessages.get(i)).trim());
                ++i;
            }
        }
        if (errorMessages != null) {
            i = 0;
            while (i < errorMessages.size()) {
                this.printMessage(2, ((String)errorMessages.get(i)).trim());
                ++i;
            }
        }
    }

    protected final String getGenerationUnitDisplayName(NamingGenerationUnitFile naming) {
        Path lAbsolutePath = new Path(naming.getAbsoluteFilePath());
        IPath lRelativePath = lAbsolutePath.removeFirstSegments(lAbsolutePath.matchingFirstSegments((IPath)new Path(this.getTargetPath())));
        return lRelativePath.setDevice(null).toString();
    }

    public final void deleteOutputFolderContent() {
        super.deleteOutputFolderContent();
        this.refreshResourceInBatch(new String[]{this.getTargetPath()});
    }

    public final void cleanup() {
        super.cleanup();
        this.setProgressMonitor(null);
        this.setResource(null);
        this.setObjectChangedCache(null);
        this.setObjectRelationEvaluator(null);
    }

    public final int getJarmLevel() {
        IPreferenceStore lPreferenceStore = GenerationPlugin.getInstance().getPreferenceStore();
        return lPreferenceStore.getInt("sapDdGenJarmLevel");
    }

    static GenerationObjectChangedCache getObjectChangedCacheForProject(String projectName) {
        MetamodelManager lMetamodelManager = MetamodelManager.getMetamodelManager((String)projectName);
        return lMetamodelManager.getGenerationObjectChangedCache();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

