/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance.utils;

import com.tssap.j2ee.core.inheritance.InhModelAccess;
import com.tssap.j2ee.internal.core.inheritance.InhModelImpl;
import com.tssap.j2ee.internal.core.inheritance.InhTypeImpl;
import com.tssap.j2ee.internal.core.inheritance.utils.FullNameUtil;
import com.tssap.j2ee.internal.core.inheritance.utils.HierarchyTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeHierarchyChangedListener;
import org.eclipse.jdt.core.JavaModelException;

public class HierarchyElement
implements ITypeHierarchyChangedListener {
    private HierarchyTree myParentTree;
    private IType myType;
    private Collection mySuperTypes = new ArrayList();
    private static final String OBJECT = (class$java$lang$Object == null ? (class$java$lang$Object = HierarchyElement.class$("java.lang.Object")) : class$java$lang$Object).getName();
    private ITypeHierarchy myTypeHierarchy;
    private Collection myCachedSubTypes = new HashSet();
    static /* synthetic */ Class class$java$lang$Object;

    HierarchyElement(HierarchyTree parentTree, IType type) {
        this.myParentTree = parentTree;
        this.myType = type;
        this.buildSuperTypes();
    }

    public void refreshSuperTypes() {
        this.mySuperTypes = new ArrayList();
        this.buildSuperTypes();
    }

    private void buildSuperTypes() {
        if (!this.myType.exists()) {
            return;
        }
        try {
            String[] superIntfs;
            boolean isInterface = this.myType.isInterface();
            if (!isInterface) {
                boolean iamObject = this.myType.getFullyQualifiedName().equals(OBJECT);
                String superClass = this.myType.getSuperclassName();
                if (superClass == null && !iamObject) {
                    superClass = OBJECT;
                }
                if (!this.addType(superClass) && !iamObject) {
                    this.addType(OBJECT);
                }
            }
            if ((superIntfs = this.myType.getSuperInterfaceNames()) != null) {
                int i = 0;
                while (i < superIntfs.length) {
                    this.addType(superIntfs[i]);
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            return;
        }
    }

    private boolean addType(String typeName) {
        IType type;
        if (typeName == null) {
            return false;
        }
        try {
            type = this.getParentTree().getJavaProject().findType(FullNameUtil.getFullName(typeName, this.myType));
        }
        catch (JavaModelException e) {
            return false;
        }
        if (type != null) {
            this.mySuperTypes.add(type);
            this.getParentTree().getHierarchyElement(type).cacheSubType(this);
        }
        return type != null;
    }

    public Collection getSuperTypes() {
        return this.mySuperTypes;
    }

    public boolean containsImmediately(String fullName) {
        if (fullName == null) {
            return false;
        }
        Iterator it = this.mySuperTypes.iterator();
        while (it.hasNext()) {
            IType next = (IType)it.next();
            if (!fullName.equals(next.getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsDeep(String fullName) {
        if (fullName == null) {
            return false;
        }
        Iterator it = this.mySuperTypes.iterator();
        while (it.hasNext()) {
            IType next = (IType)it.next();
            if (fullName.equals(next.getFullyQualifiedName())) {
                return true;
            }
            if (!this.getParentTree().getHierarchyElement(next).containsDeep(fullName)) continue;
            return true;
        }
        return false;
    }

    public HierarchyTree getParentTree() {
        return this.myParentTree;
    }

    public IType getType() {
        return this.myType;
    }

    public IType[] getSubTypes() {
        ITypeHierarchy hierarchy = this.getApplicableTypeHierarchy(true);
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.getSubtypes(this.myType);
    }

    protected ITypeHierarchy getApplicableTypeHierarchy(boolean createIfMissing) {
        if (this.myTypeHierarchy != null) {
            return this.myTypeHierarchy;
        }
        ITypeHierarchy result = null;
        Iterator it = this.mySuperTypes.iterator();
        while (result == null && it.hasNext()) {
            HierarchyElement superType = this.getParentTree().getHierarchyElement((IType)it.next());
            if (superType == null) continue;
            result = superType.getApplicableTypeHierarchy(false);
        }
        if (result == null && createIfMissing) {
            try {
                this.myTypeHierarchy = result = this.myType.newTypeHierarchy(null);
                result.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return result;
    }

    public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        IType iType = this.myType;
        synchronized (iType) {
            if (this.myType.exists()) {
                InhModelImpl model = (InhModelImpl)InhModelAccess.getModel((String)this.getParentTree().getJavaProject().getElementName());
                if (model == null) {
                    return;
                }
                final InhTypeImpl inhType = model.findCachedType(this.myType);
                if (inhType != null) {
                    model.runCommand(new Runnable(){

                        public void run() {
                            inhType.refresh();
                        }
                    });
                }
            }
            this.myTypeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.myTypeHierarchy = null;
        }
    }

    private void forgetTypeHierarchy() {
        this.myTypeHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        this.myTypeHierarchy = null;
    }

    public void onTypeHierarchyChanged() {
        HierarchyElement elementThatCachesIncorrectHierarchy = this.getHierarchyElementApplicableForTypeHierarchy();
        while (elementThatCachesIncorrectHierarchy != null) {
            elementThatCachesIncorrectHierarchy.forgetTypeHierarchy();
            elementThatCachesIncorrectHierarchy = this.getHierarchyElementApplicableForTypeHierarchy();
        }
    }

    private HierarchyElement getHierarchyElementApplicableForTypeHierarchy() {
        if (this.myTypeHierarchy != null) {
            return this;
        }
        HierarchyElement resultElement = null;
        Iterator it = this.mySuperTypes.iterator();
        while (resultElement == null && it.hasNext()) {
            HierarchyElement superType = this.getParentTree().getHierarchyElement((IType)it.next());
            if (superType == null) continue;
            resultElement = superType.getHierarchyElementApplicableForTypeHierarchy();
        }
        return resultElement;
    }

    public void cacheSubType(HierarchyElement element) {
        this.myCachedSubTypes.add(element.getType());
    }

    public IType[] getCachedSubTypes() {
        return this.myCachedSubTypes.toArray(new IType[this.myCachedSubTypes.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

