/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance.utils;

import com.tssap.j2ee.core.utils.signature.FieldSignature;
import com.tssap.j2ee.core.utils.signature.MethodSignature;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class FullNameUtil {
    private static final char DOT = '.';
    private static final String ARRAY_SUFFIX = "[]";
    private static final String JAVA_SUFFIX = ".java";

    public static String getFullName(String possiblyShortName, IType context) {
        return FullNameUtil.getFullName(possiblyShortName, context, false);
    }

    public static String getFullName(String possiblyShortName, IType context, boolean stripArrays) {
        if (possiblyShortName == null) {
            return null;
        }
        try {
            String typeSig = Signature.createTypeSignature((String)possiblyShortName, (boolean)false);
            int arrayCount = Signature.getArrayCount((String)typeSig);
            String arraylessTypeName = Signature.toString((String)Signature.getElementType((String)typeSig));
            if (stripArrays) {
                return FullNameUtil.getFullName(arraylessTypeName, context, false);
            }
            if (FullNameUtil.isSimpleType(arraylessTypeName)) {
                return possiblyShortName;
            }
            if (possiblyShortName.indexOf(46) != -1) {
                return possiblyShortName;
            }
            if (context == null) {
                return possiblyShortName;
            }
            String[][] result = context.resolveType(arraylessTypeName);
            if (result == null || result.length != 1) {
                return possiblyShortName;
            }
            if (result[0][0].length() == 0) {
                return FullNameUtil.addArrays(result[0][1], arrayCount);
            }
            return FullNameUtil.addArrays(result[0][0] + '.' + result[0][1], arrayCount);
        }
        catch (JavaModelException e) {
            return possiblyShortName;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String addArrays(String typeName, int arrayCount) {
        if (arrayCount == 0) {
            return typeName;
        }
        StringBuffer buf = new StringBuffer(typeName);
        int i = 0;
        while (i < arrayCount) {
            buf.append(ARRAY_SUFFIX);
            ++i;
        }
        return buf.toString();
    }

    public static boolean isSimpleType(String typeName) {
        return typeName != null && Signature.createTypeSignature((String)typeName, (boolean)false).length() == 1;
    }

    public static boolean isSimpleTypeOrArrayThereof(String typeName) {
        if (typeName == null) {
            return false;
        }
        try {
            String typeSig = Signature.createTypeSignature((String)typeName, (boolean)false);
            String arraylessTypeSig = Signature.getElementType((String)typeSig);
            return arraylessTypeSig.length() == 1;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static MethodSignature getSignature(IMethod method) {
        String name = method.getElementName();
        try {
            String returnType = FullNameUtil.getFullName(Signature.toString((String)method.getReturnType()), method.getDeclaringType());
            String[] paramSigs = (String[])method.getParameterTypes().clone();
            int i = 0;
            while (i < paramSigs.length) {
                paramSigs[i] = FullNameUtil.getFullName(Signature.toString((String)paramSigs[i]), method.getDeclaringType());
                ++i;
            }
            return new MethodSignature(name, paramSigs, method.getParameterNames(), returnType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public static FieldSignature getSignature(IField field) {
        String name = field.getElementName();
        try {
            String type = FullNameUtil.getFullName(Signature.toString((String)field.getTypeSignature()), field.getDeclaringType());
            return new FieldSignature(name, type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public static boolean isTypeNameToChangeOnOpenableRename(IType type) {
        if (type.isBinary()) {
            return true;
        }
        ICompilationUnit cu = type.getCompilationUnit();
        return cu.getElementName().equals(type.getElementName() + JAVA_SUFFIX);
    }
}

