/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance.properties;

import com.tssap.j2ee.internal.core.inheritance.InhElementImpl;
import com.tssap.j2ee.internal.core.inheritance.properties.IPropertyEvaluator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class PropertyService {
    private Map myCachedProperties = new HashMap();
    private Map myCachedMultiProperties = new HashMap();
    private InhElementImpl myElement;

    public PropertyService(InhElementImpl element) {
        this.myElement = element;
    }

    public String getPropertyValue(String propertyName) {
        if (this.myCachedProperties.containsKey(propertyName)) {
            return (String)this.myCachedProperties.get(propertyName);
        }
        String result = this.evaluateProperty(propertyName);
        this.myCachedProperties.put(propertyName, result);
        return result;
    }

    public String[] getPropertyValues(String propertyName) {
        if (this.myCachedMultiProperties.containsKey(propertyName)) {
            return (String[])this.myCachedMultiProperties.get(propertyName);
        }
        String[] result = this.evaluateProperties(propertyName);
        this.myCachedMultiProperties.put(propertyName, result);
        return result;
    }

    private String evaluateProperty(String propertyName) {
        IPropertyEvaluator evaluator = this.getPropertyEvaluator(propertyName);
        if (evaluator == null) {
            return null;
        }
        return evaluator.evaluateProperty(this.myElement);
    }

    private String[] evaluateProperties(String propertyName) {
        IPropertyEvaluator evaluator = this.getPropertyEvaluator(propertyName);
        if (evaluator == null) {
            return null;
        }
        return evaluator.evaluateProperties(this.myElement);
    }

    protected InhElementImpl getElement() {
        return this.myElement;
    }

    public Map refreshProperties() {
        this.refreshMultiProperties();
        return this.refreshSingleProperties();
    }

    private Map refreshMultiProperties() {
        if (this.myCachedMultiProperties == null) {
            return null;
        }
        Map oldCachedProperties = this.myCachedMultiProperties;
        this.myCachedMultiProperties = new HashMap();
        Iterator it = oldCachedProperties.entrySet().iterator();
        while (it.hasNext()) {
            Object[] newValue;
            Map.Entry next = it.next();
            String propertyName = (String)next.getKey();
            Object[] oldValue = (String[])next.getValue();
            if (!Arrays.equals(oldValue, newValue = this.getPropertyValues(propertyName))) continue;
            it.remove();
        }
        if (!oldCachedProperties.isEmpty()) {
            return oldCachedProperties;
        }
        return null;
    }

    private Map refreshSingleProperties() {
        if (this.myCachedProperties == null) {
            return null;
        }
        Map oldCachedProperties = this.myCachedProperties;
        this.myCachedProperties = new HashMap();
        Iterator it = oldCachedProperties.entrySet().iterator();
        while (it.hasNext()) {
            String newValue;
            Map.Entry next = it.next();
            String propertyName = (String)next.getKey();
            String oldValue = (String)next.getValue();
            if (!PropertyService.sameValues(oldValue, newValue = this.getPropertyValue(propertyName))) continue;
            it.remove();
        }
        if (!oldCachedProperties.isEmpty()) {
            return oldCachedProperties;
        }
        return null;
    }

    private static boolean sameValues(String one, String another) {
        if (one == null) {
            return another == null;
        }
        return one.equals(another);
    }

    protected abstract IPropertyEvaluator getPropertyEvaluator(String var1);
}

