/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance.change;

import com.tssap.j2ee.core.inheritance.InhElement;
import com.tssap.j2ee.core.inheritance.change.InhChange;
import com.tssap.j2ee.core.inheritance.change.InhChangeType;
import java.util.Map;

public class InhChangeImpl
implements InhChange {
    private InhChangeType myChangeType;
    private InhElement myElement;
    private Map myChangedProperties;
    private String myOldFullName;

    public InhChangeImpl(InhChangeType changeType, InhElement element, Map changedProperties, String oldFullName) {
        this.myChangeType = changeType;
        this.myElement = element;
        this.myChangedProperties = changedProperties;
        this.myOldFullName = oldFullName;
    }

    public InhChangeType getChangeType() {
        return this.myChangeType;
    }

    public InhElement getElement() {
        return this.myElement;
    }

    public Map getChangedProperties() {
        return this.myChangedProperties;
    }

    public String getOldFullName() {
        return this.myOldFullName;
    }

    public void merge(InhChangeImpl change) {
        if (this.myChangeType == InhChangeType.NEW) {
            this.mergeNew(change);
        } else if (this.myChangeType == InhChangeType.DELETED) {
            this.mergeDeleted(change);
        } else if (this.myChangeType == InhChangeType.CHANGED) {
            this.mergeChanged(change);
        } else if (this.myChangeType == InhChangeType.UIN_CHANGED) {
            this.mergeUinChanged(change);
        }
    }

    private void mergeNew(InhChangeImpl change) {
        if (change.getChangeType() == InhChangeType.NEW || change.getChangeType() == InhChangeType.CHANGED) {
            return;
        }
        if (change.getChangeType() == InhChangeType.UIN_CHANGED) {
            this.myOldFullName = change.getOldFullName();
            System.out.println("InhChangeImpl.mergeNew()::maybe incorrect behavior");
        } else if (change.getChangeType() == InhChangeType.DELETED) {
            this.myElement = null;
        }
    }

    private void mergeDeleted(InhChangeImpl change) {
        if (change.getChangeType() == InhChangeType.DELETED || change.getChangeType() == InhChangeType.CHANGED) {
            return;
        }
        if (change.getChangeType() == InhChangeType.UIN_CHANGED) {
            this.myChangeType = InhChangeType.UIN_CHANGED;
            this.myOldFullName = change.getOldFullName();
            System.out.println("InhChangeImpl.mergeDeleted()::maybe incorrect behavior");
        } else if (change.getChangeType() == InhChangeType.NEW) {
            this.myChangeType = InhChangeType.CHANGED;
        }
    }

    private void mergeChanged(InhChangeImpl change) {
        this.myChangedProperties = this.mergeProperties(this.myChangedProperties, change.getChangedProperties());
        this.myOldFullName = change.getOldFullName();
        this.myChangeType = this.getChangeType();
    }

    private void mergeUinChanged(InhChangeImpl change) {
        System.out.println("InhChangeImpl.mergeUinChanged():: not clear what to do");
    }

    private Map mergeProperties(Map first, Map second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        first.putAll(second);
        return first;
    }

    public String getEffectiveFullName() {
        if (this.myOldFullName != null) {
            return this.myOldFullName;
        }
        if (this.getElement() == null) {
            return null;
        }
        return this.getElement().getFullName();
    }
}

