/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance;

import com.tssap.j2ee.core.inheritance.change.InhChangeType;
import com.tssap.j2ee.internal.core.inheritance.InhModelImpl;
import com.tssap.j2ee.internal.core.inheritance.InhTypeImpl;
import com.tssap.j2ee.internal.core.inheritance.TypeDeltaProcessor;
import com.tssap.j2ee.internal.core.inheritance.change.InhChangeImpl;
import com.tssap.j2ee.internal.core.inheritance.utils.FullNameUtil;
import com.tssap.j2ee.internal.core.inheritance.utils.HierarchyElement;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class RemovedTypeDeltaProcessor
extends TypeDeltaProcessor {
    private IType myRenamedElement;

    public RemovedTypeDeltaProcessor(InhModelImpl model) {
        super(model);
    }

    public RemovedTypeDeltaProcessor(InhModelImpl model, IType type) {
        super(model, type);
    }

    public void processIndividualDelta(IJavaElementDelta delta) {
        super.processIndividualDelta(delta);
        if ((delta.getFlags() & 0x20) != 0) {
            this.setRenamedElement(this.findRenamedElement(delta.getMovedToElement()));
        }
        this.processRemovedType(this.getAffectedType());
    }

    private IType findRenamedElement(IJavaElement movedToElement) {
        if (movedToElement == null) {
            return null;
        }
        try {
            switch (movedToElement.getElementType()) {
                case 3: {
                    return this.findRenamedElementInPFR((IPackageFragmentRoot)movedToElement, this.getAffectedType());
                }
                case 4: {
                    return this.findRenamedElementInPF((IPackageFragment)movedToElement, this.getAffectedType());
                }
                case 6: {
                    return this.findRenamedElementInCF((IClassFile)movedToElement, this.getAffectedType());
                }
                case 5: {
                    return this.findRenamedElementInCU((ICompilationUnit)movedToElement, this.getAffectedType());
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private IType findRenamedElementInPFR(IPackageFragmentRoot afterState, IType beforeState) throws JavaModelException {
        return this.findRenamedElementInPF(afterState.getPackageFragment(beforeState.getPackageFragment().getElementName()), beforeState);
    }

    private IType findRenamedElementInPF(IPackageFragment afterState, IType beforeState) throws JavaModelException {
        if (afterState.getKind() == 2 && beforeState.isBinary()) {
            return this.findRenamedElementInCF(afterState.getClassFile(beforeState.getClassFile().getElementName()), beforeState);
        }
        if (afterState.getKind() == 1 && !beforeState.isBinary()) {
            return this.findRenamedElementInCU(afterState.getCompilationUnit(beforeState.getCompilationUnit().getElementName()), beforeState);
        }
        return null;
    }

    private IType findRenamedElementInCF(IClassFile afterState, IType beforeState) throws JavaModelException {
        return afterState.getType();
    }

    private IType findRenamedElementInCU(ICompilationUnit afterState, IType beforeState) {
        if (FullNameUtil.isTypeNameToChangeOnOpenableRename(beforeState)) {
            return afterState.findPrimaryType();
        }
        return afterState.getType(beforeState.getElementName());
    }

    private void processRemovedType(IType type) {
        HierarchyElement hierElement;
        InhTypeImpl inhType = this.getModel().findCachedType(type);
        if (inhType != null) {
            if (this.getRenamedElement() == null) {
                this.getModel().getCurrentChangeEvent().addTypeChange(new InhChangeImpl(InhChangeType.DELETED, inhType, null, null));
            } else {
                this.getModel().getCurrentChangeEvent().addTypeChange(new InhChangeImpl(InhChangeType.UIN_CHANGED, this.getModel().findType(this.getRenamedElement()), null, this.getAffectedType().getFullyQualifiedName('.')));
            }
            inhType.refreshSubTypes();
        }
        if ((hierElement = this.getModel().getHierarchyTree().findCachedHierarchyElement(type)) != null) {
            hierElement.onTypeHierarchyChanged();
        }
    }

    protected IType getRenamedElement() {
        return this.myRenamedElement;
    }

    protected void setRenamedElement(IType element) {
        if (element != null && element.getJavaProject().equals(this.getModel().getJavaProject())) {
            this.myRenamedElement = element;
        }
    }
}

