/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance;

import com.tssap.j2ee.internal.core.inheritance.AbstractJavaElementDeltaProcessor;
import com.tssap.j2ee.internal.core.inheritance.InhModelImpl;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public abstract class OpenableDeltaProcessor
extends AbstractJavaElementDeltaProcessor {
    private IJavaElement myOpenable;

    public OpenableDeltaProcessor(InhModelImpl model, IJavaElement openable) {
        super(model);
        this.myOpenable = openable;
    }

    public OpenableDeltaProcessor(InhModelImpl model) {
        super(model);
    }

    public void processIndividualDelta(IJavaElementDelta delta) {
        super.processIndividualDelta(delta);
        if (this.myOpenable == null && (delta.getElement().getElementType() == 5 || delta.getElement().getElementType() == 6)) {
            this.myOpenable = delta.getElement();
        }
        IType[] affectedTypes = this.getAffectedTypes(this.getAffectedOpenable());
        this.processIndividualDelta(delta, affectedTypes);
    }

    protected abstract void processIndividualDelta(IJavaElementDelta var1, IType[] var2);

    private IJavaElement getAffectedOpenable() {
        return this.myOpenable;
    }

    private IType[] getAffectedTypes(IJavaElement element) {
        try {
            switch (element.getElementType()) {
                case 6: {
                    return new IType[]{((IClassFile)element).getType()};
                }
                case 5: {
                    if (element.exists()) {
                        return ((ICompilationUnit)element).getTypes();
                    }
                    return this.getModel().getTypeCacher().getCachedTypes((ICompilationUnit)element);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return new IType[0];
    }
}

