/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance;

import com.tssap.j2ee.core.inheritance.InhElement;
import com.tssap.j2ee.core.inheritance.InhMember;
import com.tssap.j2ee.core.inheritance.InhType;
import com.tssap.j2ee.core.inheritance.change.InhChangeType;
import com.tssap.j2ee.core.utils.signature.AbstractSignature;
import com.tssap.j2ee.core.utils.signature.FieldSignature;
import com.tssap.j2ee.core.utils.signature.MethodSignature;
import com.tssap.j2ee.internal.core.inheritance.InhAttributeImpl;
import com.tssap.j2ee.internal.core.inheritance.InhElementImpl;
import com.tssap.j2ee.internal.core.inheritance.InhMemberImpl;
import com.tssap.j2ee.internal.core.inheritance.InhMethodImpl;
import com.tssap.j2ee.internal.core.inheritance.InhModelImpl;
import com.tssap.j2ee.internal.core.inheritance.change.InhChangeImpl;
import com.tssap.j2ee.internal.core.inheritance.properties.PropertyService;
import com.tssap.j2ee.internal.core.inheritance.properties.TypePropertyService;
import com.tssap.j2ee.internal.core.inheritance.utils.FullNameUtil;
import com.tssap.j2ee.internal.core.inheritance.utils.HierarchyElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class InhTypeImpl
extends InhElementImpl
implements InhType {
    private IType myType;
    private Map myMemberSignatures2Members;
    private InhModelImpl myModel;
    private TypePropertyService myPropertyService;

    InhTypeImpl(InhModelImpl model, IType type) {
        this.myModel = model;
        this.myType = type;
        this.getModel().getTypeCacher().cacheType(type);
        this.myMemberSignatures2Members = this.collectMembers();
    }

    private Map collectMembers() {
        HashMap result = new HashMap();
        this.collectMembers(result, this.getJDTType());
        return result;
    }

    private void collectMembers(Map result, IType type) {
        boolean considerPrivate = type.equals(this.getJDTType());
        boolean considerPackageLocal = considerPrivate || type.getPackageFragment().getElementName().equals(this.getJDTType().getPackageFragment().getElementName());
        this.collectMethods(result, type, considerPrivate, considerPackageLocal);
        this.collectFields(result, type, considerPrivate, considerPackageLocal);
        HierarchyElement hierarchy = this.getModel().getHierarchyTree().getHierarchyElement(type);
        Iterator it = hierarchy.getSuperTypes().iterator();
        while (it.hasNext()) {
            IType next = (IType)it.next();
            this.getModel().findType(next);
            this.collectMembers(result, next);
        }
    }

    private void collectMethods(Map result, IType type, boolean privateAccepted, boolean packageLocalAccepted) {
        IMethod[] methods;
        try {
            methods = type.getMethods();
        }
        catch (JavaModelException e) {
            methods = new IMethod[]{};
        }
        int i = 0;
        while (i < methods.length) {
            InhMemberImpl resultingMember;
            MethodSignature signature;
            IMethod next = methods[i];
            if (this.visibleMember((IMember)next, privateAccepted, packageLocalAccepted) && (signature = FullNameUtil.getSignature(next)) != null && (resultingMember = (InhMemberImpl)result.get(signature)) == null) {
                resultingMember = new InhMethodImpl(this, next, signature);
                result.put(signature, resultingMember);
            }
            ++i;
        }
    }

    private void collectFields(Map result, IType type, boolean privateAccepted, boolean packageLocalAccepted) {
        IField[] fields;
        try {
            fields = type.getFields();
        }
        catch (JavaModelException e) {
            fields = new IField[]{};
        }
        int i = 0;
        while (i < fields.length) {
            InhMemberImpl resultingMember;
            FieldSignature signature;
            IField next = fields[i];
            if (this.visibleMember((IMember)next, privateAccepted, packageLocalAccepted) && (signature = FullNameUtil.getSignature(next)) != null && (resultingMember = (InhMemberImpl)result.get(signature)) == null) {
                resultingMember = new InhAttributeImpl(this, next, signature);
                result.put(signature, resultingMember);
            }
            ++i;
        }
    }

    private boolean visibleMember(IMember member, boolean privateAccepted, boolean packageLocalAccepted) {
        try {
            if (member.getElementType() == 9 && ((IMethod)member).isConstructor()) {
                return privateAccepted;
            }
            int flags = member.getFlags();
            if (Flags.isPrivate((int)flags)) {
                return privateAccepted;
            }
            if (!Flags.isPublic((int)flags) && !Flags.isProtected((int)flags)) {
                return packageLocalAccepted;
            }
            return true;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public InhMember[] getMembers() {
        return this.myMemberSignatures2Members.values().toArray(new InhMember[this.myMemberSignatures2Members.size()]);
    }

    public InhMember[] children(String metaclass) {
        if (!"attribute".equals(metaclass) && !"method".equals(metaclass)) {
            return null;
        }
        InhMember[] members = this.getMembers();
        ArrayList<InhMember> result = new ArrayList<InhMember>();
        int i = 0;
        while (i < members.length) {
            if (metaclass.equals(members[i].getMetaclass())) {
                result.add(members[i]);
            }
            ++i;
        }
        return result.toArray(new InhMember[result.size()]);
    }

    public InhMember childBySignature(String signature) {
        AbstractSignature sig = this.createSignature(signature);
        if (sig == null) {
            return null;
        }
        return (InhMember)this.myMemberSignatures2Members.get(sig);
    }

    public boolean derivedFrom(String fullName) {
        if (fullName == null) {
            return false;
        }
        HierarchyElement me = this.getModel().getHierarchyTree().getHierarchyElement(this.getJDTType());
        return me.containsDeep(fullName);
    }

    public boolean exists() {
        return this.myType != null && this.myType.exists();
    }

    protected InhElement[] baseElements() {
        HierarchyElement mySelf = this.getModel().getHierarchyTree().getHierarchyElement(this.getJDTType());
        if (mySelf == null) {
            return null;
        }
        Collection superTypes = mySelf.getSuperTypes();
        ArrayList<InhTypeImpl> result = new ArrayList<InhTypeImpl>(superTypes.size());
        Iterator it = superTypes.iterator();
        while (it.hasNext()) {
            InhTypeImpl type;
            IType next = (IType)it.next();
            if (next == null || (type = this.getModel().findType(next)) == null) continue;
            result.add(type);
        }
        return result.toArray(new InhElement[result.size()]);
    }

    protected InhElement[] derivedElements() {
        HierarchyElement mySelf = this.getModel().getHierarchyTree().getHierarchyElement(this.getJDTType());
        if (mySelf == null) {
            return null;
        }
        IType[] subTypes = mySelf.getSubTypes();
        if (subTypes == null) {
            return InhElementImpl.NONE;
        }
        ArrayList<InhTypeImpl> result = new ArrayList<InhTypeImpl>(subTypes.length);
        int i = 0;
        while (i < subTypes.length) {
            InhTypeImpl type;
            IType next = subTypes[i];
            if (next != null && (type = this.getModel().findType(next)) != null) {
                result.add(type);
            }
            ++i;
        }
        return result.toArray(new InhElement[result.size()]);
    }

    private AbstractSignature createSignature(String signature) {
        if (signature == null) {
            return null;
        }
        if (signature.indexOf(40) != -1) {
            return MethodSignature.fromUMLRepresentation((String)signature);
        }
        return FieldSignature.fromUMLRepresentation((String)signature);
    }

    public IType getJDTType() {
        return this.myType;
    }

    public InhModelImpl getModel() {
        return this.myModel;
    }

    protected PropertyService getPropertyService() {
        if (this.myPropertyService == null) {
            this.myPropertyService = new TypePropertyService(this);
        }
        return this.myPropertyService;
    }

    public void refreshSubTypes() {
        HierarchyElement hierElement = this.getJDTType().exists() ? this.getModel().getHierarchyTree().getHierarchyElement(this.getJDTType()) : this.getModel().getHierarchyTree().findCachedHierarchyElement(this.getJDTType());
        if (hierElement == null) {
            return;
        }
        IType[] subtypes = hierElement.getCachedSubTypes();
        int i = 0;
        while (i < subtypes.length) {
            InhTypeImpl subType = this.getModel().findCachedType(subtypes[i]);
            if (subType != null) {
                subType.refresh();
            }
            ++i;
        }
    }

    public void refresh() {
        this.refreshSuperTypes();
        this.refreshMembers();
        this.refreshProperties();
        this.refreshSubTypes();
    }

    public void refreshSuperTypes() {
        HierarchyElement hier = this.getModel().getHierarchyTree().findCachedHierarchyElement(this.getJDTType());
        if (hier == null) {
            return;
        }
        hier.refreshSuperTypes();
    }

    public void refreshMembers() {
        Map oldMemberSignatures2Members = this.myMemberSignatures2Members;
        this.myMemberSignatures2Members = this.collectMembers();
        Iterator it = oldMemberSignatures2Members.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            Object key = next.getKey();
            InhMemberImpl oldState = (InhMemberImpl)next.getValue();
            InhMemberImpl newState = (InhMemberImpl)this.myMemberSignatures2Members.get(key);
            if (newState == null) {
                this.getModel().getCurrentChangeEvent().addMemberChange(new InhChangeImpl(InhChangeType.DELETED, oldState, null, null));
                it.remove();
                continue;
            }
            oldState.refreshProperties();
        }
        Iterator it2 = this.myMemberSignatures2Members.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry next = it2.next();
            Object key = next.getKey();
            if (oldMemberSignatures2Members.containsKey(key)) continue;
            InhMemberImpl added = (InhMemberImpl)next.getValue();
            this.getModel().getCurrentChangeEvent().addMemberChange(new InhChangeImpl(InhChangeType.NEW, added, null, null));
        }
    }

    protected void reportChangedProperties(Map changedProperties) {
        this.getModel().getCurrentChangeEvent().addTypeChange(new InhChangeImpl(InhChangeType.CHANGED, this, changedProperties, null));
    }
}

