/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance;

import com.tssap.j2ee.core.inheritance.InhMember;
import com.tssap.j2ee.core.inheritance.InhModel;
import com.tssap.j2ee.core.inheritance.InhType;
import com.tssap.j2ee.core.inheritance.change.InhChange;
import com.tssap.j2ee.core.inheritance.change.InhChangeEvent;
import com.tssap.j2ee.core.inheritance.change.InhChangeType;
import com.tssap.j2ee.core.inheritance.change.InhChangesListener;
import com.tssap.j2ee.core.inheritance.change.InhCompositeChange;
import com.tssap.j2ee.internal.core.inheritance.AddedOpenableDeltaProcessor;
import com.tssap.j2ee.internal.core.inheritance.ChangedOpenableDeltaProcessor;
import com.tssap.j2ee.internal.core.inheritance.IJavaElementDeltaProcessor;
import com.tssap.j2ee.internal.core.inheritance.ImplPlugin;
import com.tssap.j2ee.internal.core.inheritance.InhTypeImpl;
import com.tssap.j2ee.internal.core.inheritance.RemovedOpenableDeltaProcessor;
import com.tssap.j2ee.internal.core.inheritance.RemovedPFRDeltaProcessor;
import com.tssap.j2ee.internal.core.inheritance.RemovedTypeDeltaProcessor;
import com.tssap.j2ee.internal.core.inheritance.change.InhChangeEventImpl;
import com.tssap.j2ee.internal.core.inheritance.utils.HierarchyTree;
import com.tssap.j2ee.internal.core.inheritance.utils.TypeCacher;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class InhModelImpl
implements InhModel,
IJavaElementDeltaProcessor {
    private IProject myProject;
    private IJavaProject myJavaProject;
    private HierarchyTree myHierarchyTree;
    private TypeCacher myTypeCacher;
    private ArrayList myListeners = new ArrayList();
    private HashMap myFullNames2InhTypes = new HashMap();
    private InhChangeEventImpl myChangeEvent;
    private static final char DOT = '.';
    private static final char LBRACKET = '(';

    public InhModelImpl(IProject project) {
        this.myProject = project;
        this.myJavaProject = JavaCore.create((IProject)this.myProject);
        this.myHierarchyTree = new HierarchyTree(this);
        this.myTypeCacher = new TypeCacher();
    }

    public InhTypeImpl findType(IType type) {
        return (InhTypeImpl)this.findType(type.getFullyQualifiedName('.'));
    }

    public InhType findType(String fullName) {
        if (fullName == null) {
            return null;
        }
        InhTypeImpl result = this.findCachedType(fullName);
        if (result != null) {
            if (!result.exists()) {
                this.myFullNames2InhTypes.remove(fullName);
                return null;
            }
            return result;
        }
        try {
            IType type = this.myJavaProject.findType(fullName);
            if (type == null) {
                return null;
            }
            result = new InhTypeImpl(this, type);
            this.myFullNames2InhTypes.put(fullName, result);
        }
        catch (JavaModelException e) {
            return null;
        }
        return result;
    }

    public InhTypeImpl findCachedType(String fullName) {
        return (InhTypeImpl)this.myFullNames2InhTypes.get(fullName);
    }

    public InhTypeImpl findCachedType(IType type) {
        return this.findCachedType(type.getFullyQualifiedName('.'));
    }

    public InhMember findMember(String fullName) {
        if (fullName == null) {
            return null;
        }
        int lbracket = fullName.indexOf(40);
        String nameOnly = lbracket == -1 ? fullName : fullName.substring(0, lbracket);
        int lastDot = nameOnly.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        String typeFQN = nameOnly.substring(0, lastDot);
        InhType type = this.findType(typeFQN);
        if (type == null) {
            return null;
        }
        String signature = fullName.substring(lastDot + 1);
        return type.childBySignature(signature);
    }

    public void addInhChangeListener(InhChangesListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeInhChangeListener(InhChangesListener listener) {
        ((AbstractCollection)this.myListeners).remove(listener);
    }

    public IJavaProject getJavaProject() {
        return this.myJavaProject;
    }

    public HierarchyTree getHierarchyTree() {
        return this.myHierarchyTree;
    }

    public synchronized void processDelta(final IJavaElementDelta delta) {
        this.runCommand(new Runnable(){

            public void run() {
                InhModelImpl.this.doProcessDelta(delta);
            }
        });
    }

    public synchronized void runCommand(Runnable command) {
        if (this.myChangeEvent != null) {
            ImplPlugin.getDefault().logWarning("Java Delta arrived before the previous delta was processed.");
        } else {
            this.myChangeEvent = new InhChangeEventImpl(this);
        }
        try {
            command.run();
            Object var3_2 = null;
            this.reportChanges();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.reportChanges();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void reportChanges() {
        int i2;
        InhChange[] deletedTypes2;
        Throwable throwable2;
        block8: {
            InhCompositeChange changedTypes2;
            try {
                if (!this.myChangeEvent.isEmpty()) {
                    Iterator it = ((AbstractList)((ArrayList)this.myListeners.clone())).iterator();
                    while (true) {
                        if (!it.hasNext()) {
                            break;
                        }
                        InhChangesListener next = (InhChangesListener)it.next();
                        next.inhModelChanged((InhChangeEvent)this.myChangeEvent);
                    }
                }
                Object var4_3 = null;
                changedTypes2 = this.myChangeEvent.getTypeChanges();
            }
            catch (Throwable throwable2) {
                Object var4_4 = null;
                InhCompositeChange changedTypes2 = this.myChangeEvent.getTypeChanges();
                deletedTypes2 = changedTypes2.getEvents(InhChangeType.DELETED);
                i2 = 0;
                break block8;
            }
            InhChange[] deletedTypes2 = changedTypes2.getEvents(InhChangeType.DELETED);
            int i2 = 0;
            while (true) {
                if (i2 >= deletedTypes2.length) break;
                this.myFullNames2InhTypes.remove(deletedTypes2[i2].getElement().getFullName());
                ++i2;
            }
            this.myChangeEvent = null;
            return;
        }
        while (true) {
            if (i2 >= deletedTypes2.length) {
                this.myChangeEvent = null;
                throw throwable2;
            }
            this.myFullNames2InhTypes.remove(deletedTypes2[i2].getElement().getFullName());
            ++i2;
        }
    }

    void doProcessDelta(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 2: {
                this.processChildren(delta);
                break;
            }
            case 3: {
                this.processPackageFragmentRootChanges(delta);
                break;
            }
            case 4: {
                this.processPackageFragmentChanges(delta);
                break;
            }
            case 5: 
            case 6: {
                this.processOpenableChanges(delta);
                break;
            }
            case 7: {
                this.processTypeChanges(delta);
                break;
            }
            case 8: 
            case 9: {
                this.processMemberChanges(delta);
                break;
            }
            case 12: {
                this.processChildren(delta);
                break;
            }
            case 13: {
                this.processImportChanges(delta);
            }
        }
    }

    private void processPackageFragmentRootChanges(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                new RemovedPFRDeltaProcessor(this).processIndividualDelta(delta);
                break;
            }
            case 4: {
                this.processChildren(delta);
            }
        }
    }

    private void processPackageFragmentChanges(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                new RemovedPFRDeltaProcessor(this).processIndividualDelta(delta);
                break;
            }
            case 4: {
                this.processChildren(delta);
            }
        }
    }

    private void processOpenableChanges(IJavaElementDelta delta) {
        IJavaElement elementInQuestion = delta.getElement();
        if (elementInQuestion.getElementType() == 5 && ((ICompilationUnit)elementInQuestion).isWorkingCopy()) {
            return;
        }
        switch (delta.getKind()) {
            case 1: {
                new AddedOpenableDeltaProcessor(this).processIndividualDelta(delta);
                break;
            }
            case 2: {
                new RemovedOpenableDeltaProcessor(this).processIndividualDelta(delta);
                break;
            }
            case 4: {
                new ChangedOpenableDeltaProcessor(this).processIndividualDelta(delta);
                this.processChildren(delta);
            }
        }
    }

    private void processTypeChanges(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                new RemovedTypeDeltaProcessor(this).processIndividualDelta(delta);
                break;
            }
            case 4: {
                this.processChildren(delta);
            }
        }
    }

    private void processMemberChanges(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.processChildren(delta);
            }
        }
    }

    private void processImportChanges(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.processChildren(delta);
            }
        }
    }

    protected void processChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] childDeltas = delta.getAffectedChildren();
        int i = 0;
        while (i < childDeltas.length) {
            this.doProcessDelta(childDeltas[i]);
            ++i;
        }
    }

    public InhChangeEventImpl getCurrentChangeEvent() {
        return this.myChangeEvent;
    }

    public TypeCacher getTypeCacher() {
        return this.myTypeCacher;
    }
}

