/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance;

import com.tssap.j2ee.core.inheritance.InhModel;
import com.tssap.j2ee.core.inheritance.InhModelAccess;
import com.tssap.j2ee.internal.core.inheritance.InhModelImpl;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;

public class InhModelAccessImpl
extends InhModelAccess
implements IResourceChangeListener,
IElementChangedListener {
    private HashMap myProjectNames2InhModels = new HashMap();

    public InhModelAccessImpl() {
        InhModelAccess.setImplementation((InhModelAccess)this);
    }

    protected synchronized InhModel model(String projectName) {
        IProject project;
        InhModel result = (InhModel)this.myProjectNames2InhModels.get(projectName);
        if (result == null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
            result = new InhModelImpl(project);
            this.myProjectNames2InhModels.put(projectName, result);
        }
        return result;
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        if (event.getResource().getType() != 4) {
            return;
        }
        this.myProjectNames2InhModels.remove(event.getResource().getName());
    }

    public synchronized void elementChanged(ElementChangedEvent event) {
        if (event.getType() != 1) {
            return;
        }
        this.processDelta(event.getDelta());
    }

    private void processDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: {
                this.processChildDeltas(delta.getAffectedChildren());
                break;
            }
            case 2: {
                this.processProjectDelta(delta);
                break;
            }
        }
    }

    private void processChildDeltas(IJavaElementDelta[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            this.processDelta(deltas[i]);
            ++i;
        }
    }

    private void processProjectDelta(IJavaElementDelta delta) {
        String projectName = delta.getElement().getElementName();
        if (!this.myProjectNames2InhModels.containsKey(projectName)) {
            return;
        }
        InhModelImpl model = (InhModelImpl)InhModelAccess.getModel((String)projectName);
        model.processDelta(delta);
    }
}

