/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance;

import com.tssap.j2ee.core.inheritance.InhDirection;
import com.tssap.j2ee.core.inheritance.InhElement;
import com.tssap.j2ee.core.inheritance.InhMember;
import com.tssap.j2ee.core.inheritance.InhType;
import com.tssap.j2ee.core.inheritance.change.InhChangeType;
import com.tssap.j2ee.core.inheritance.visit.InhVisitor;
import com.tssap.j2ee.core.inheritance.visit.NextVisit;
import com.tssap.j2ee.core.utils.signature.AbstractSignature;
import com.tssap.j2ee.internal.core.inheritance.InhElementImpl;
import com.tssap.j2ee.internal.core.inheritance.InhModelImpl;
import com.tssap.j2ee.internal.core.inheritance.InhTypeImpl;
import com.tssap.j2ee.internal.core.inheritance.change.InhChangeImpl;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jdt.core.IMember;

public abstract class InhMemberImpl
extends InhElementImpl
implements InhMember {
    private InhTypeImpl myParent;
    private IMember myMember;
    private AbstractSignature mySignature;

    public InhMemberImpl(InhTypeImpl parent, IMember member, AbstractSignature signature) {
        this.myParent = parent;
        this.myMember = member;
        this.mySignature = signature;
    }

    public InhType getParentType() {
        return this.myParent;
    }

    protected InhModelImpl getModel() {
        return ((InhTypeImpl)this.getParentType()).getModel();
    }

    public boolean hasSource() {
        return this.myParent.getJDTType().equals(this.myMember.getDeclaringType());
    }

    public IMember getMember() {
        return this.myMember;
    }

    public AbstractSignature getElementSignature() {
        return this.mySignature;
    }

    public InhElement[] existingHierarchyElements(InhDirection direction) {
        final ArrayList result = new ArrayList();
        this.deepVisit(new InhVisitor(){

            public NextVisit visit(InhElement inhElement) {
                if (inhElement == null) {
                    return NextVisit.NEXT_PATH;
                }
                if (((InhMember)inhElement).hasSource()) {
                    result.add(inhElement);
                    return NextVisit.NEXT_PATH;
                }
                return NextVisit.CONTINUE;
            }
        }, direction);
        return result.toArray(new InhElement[result.size()]);
    }

    protected InhElement[] baseElements() {
        return this.extractElementsFromTypeHierarchy(this.myParent.baseElements());
    }

    protected InhElement[] derivedElements() {
        return this.extractElementsFromTypeHierarchy(this.myParent.derivedElements());
    }

    private InhElement[] extractElementsFromTypeHierarchy(InhElement[] types) {
        if (types == null) {
            return null;
        }
        String signature = this.getSignature();
        ArrayList<InhMember> result = new ArrayList<InhMember>(types.length);
        int i = 0;
        while (i < types.length) {
            InhMember nextMember;
            InhType nextType = (InhType)types[i];
            if (nextType != null && (nextMember = nextType.childBySignature(signature)) != null) {
                result.add(nextMember);
            }
            ++i;
        }
        return result.toArray(new InhElement[result.size()]);
    }

    protected void reportChangedProperties(Map changedProperties) {
        this.getModel().getCurrentChangeEvent().addMemberChange(new InhChangeImpl(InhChangeType.CHANGED, this, changedProperties, null));
    }
}

