/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.internal.core.inheritance;

import com.tssap.j2ee.core.inheritance.InhDirection;
import com.tssap.j2ee.core.inheritance.InhElement;
import com.tssap.j2ee.core.inheritance.visit.InhVisitor;
import com.tssap.j2ee.core.inheritance.visit.NextVisit;
import com.tssap.j2ee.internal.core.inheritance.InhModelImpl;
import com.tssap.j2ee.internal.core.inheritance.properties.PropertyService;
import java.util.Map;

public abstract class InhElementImpl
implements InhElement {
    protected static final InhElement[] NONE = new InhElement[0];

    public final InhElement[] hierarchyElements(InhDirection direction) {
        if (direction == null) {
            return null;
        }
        if (InhDirection.BASE.equals(direction)) {
            return this.baseElements();
        }
        return this.derivedElements();
    }

    protected abstract InhElement[] baseElements();

    protected abstract InhElement[] derivedElements();

    public void deepVisit(InhVisitor visitor, InhDirection direction) {
        if (visitor == null) {
            throw new NullPointerException("Null visitor");
        }
        InhElementImpl.visit(this, visitor, direction);
    }

    private static NextVisit visit(InhElement caller, InhVisitor visitor, InhDirection direction) {
        NextVisit result = null;
        InhElement[] inhElements = caller.hierarchyElements(direction);
        if (inhElements == null) {
            return null;
        }
        int i = 0;
        while (i < inhElements.length) {
            result = visitor.visit(inhElements[i]);
            if (NextVisit.CONTINUE.equals(result)) {
                result = InhElementImpl.visit(inhElements[i], visitor, direction);
            }
            if (NextVisit.STOP.equals(result)) break;
            ++i;
        }
        return result;
    }

    public final String getName() {
        return this.getPropertyValue("name");
    }

    public final String getFullName() {
        return this.getPropertyValue("full_name");
    }

    public final String getSignature() {
        return this.getPropertyValue("signature");
    }

    public final String getMetaclass() {
        return this.getPropertyValue("metaclass");
    }

    public final String getVisibility() {
        return this.getPropertyValue("visibility");
    }

    public final String getPackage() {
        return this.getPropertyValue("package");
    }

    public final String getBaseNodes() {
        return this.getPropertyValue("baseFullNames");
    }

    public final String[] getBaseNodesAsArray() {
        return this.getPropertyValues("baseFullNames");
    }

    public final String getType() {
        return this.getPropertyValue("type");
    }

    public final String getThrownExceptions() {
        return this.getPropertyValue("throws");
    }

    public final String[] getThrownExceptionsAsArray() {
        return this.getPropertyValues("throws");
    }

    public final String getParameterTypes() {
        return this.getPropertyValue("parameter");
    }

    public final String[] getParameterTypesAsArray() {
        return this.getPropertyValues("parameter");
    }

    public final String getParameterNames() {
        return this.getPropertyValue("parameter_names");
    }

    public final String[] getParameterNamesAsArray() {
        return this.getPropertyValues("parameter_names");
    }

    public final String getModifiers() {
        return this.getPropertyValue("modifiers");
    }

    public final String[] getModifiersAsArray() {
        return this.getPropertyValues("modifiers");
    }

    public final String getPropertyValue(String propertyName) {
        return this.getPropertyService().getPropertyValue(propertyName);
    }

    private final String[] getPropertyValues(String propertyName) {
        return this.getPropertyService().getPropertyValues(propertyName);
    }

    protected abstract InhModelImpl getModel();

    public final void refreshProperties() {
        Map changedProperties = this.getPropertyService().refreshProperties();
        if (changedProperties != null && !changedProperties.isEmpty()) {
            this.reportChangedProperties(changedProperties);
        }
    }

    protected abstract void reportChangedProperties(Map var1);

    protected abstract PropertyService getPropertyService();
}

